/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import java.util.TimerTask;

public class ODistributedServerLeaderChecker
extends TimerTask {
    private ODistributedServerManager manager;
    private long heartBeatDelay;

    public ODistributedServerLeaderChecker(ODistributedServerManager iManager) {
        this.manager = iManager;
        this.heartBeatDelay = this.manager.getNetworkHeartbeatDelay() * 130 / 100;
    }

    @Override
    public void run() {
        if (this.manager.isLeader()) {
            this.cancel();
            return;
        }
        if (this.manager.getStatus() != ODistributedServerManager.STATUS.ONLINE) {
            return;
        }
        long time = System.currentTimeMillis() - this.manager.getLastHeartBeat();
        if (time > this.heartBeatDelay) {
            OLogManager.instance().warn((Object)this, "No heartbeat message has been received from the Leader node (last was %d ms ago)", new Object[]{time});
            this.cancel();
            this.manager.becameLeader(false);
        }
    }
}

