/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler.distributed;

import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerNodeRemote;
import java.util.List;
import java.util.TimerTask;

public class ODistributedServerNodeChecker
extends TimerTask {
    private ODistributedServerManager manager;

    public ODistributedServerNodeChecker(ODistributedServerManager manager) {
        this.manager = manager;
    }

    @Override
    public void run() {
        List<ODistributedServerNodeRemote> nodeList = this.manager.getNodeList();
        if (nodeList == null) {
            return;
        }
        try {
            for (ODistributedServerNodeRemote node : nodeList) {
                if (node.getStatus() != ODistributedServerNodeRemote.STATUS.CONNECTED || node.sendHeartBeat(this.manager.networkTimeoutLeader)) continue;
                this.manager.handleNodeFailure(node);
            }
            nodeList.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

