/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler.distributed;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import com.orientechnologies.orient.server.handler.distributed.ODistributedException;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.handler.distributed.ODistributedSynchronizationException;
import java.io.IOException;

public class ODistributedServerRecordHook
implements ORecordHook,
ODatabaseLifecycleListener {
    private ODistributedServerManager manager;

    public ODistributedServerRecordHook(ODistributedServerManager iDistributedServerManager) {
        this.manager = iDistributedServerManager;
        Orient.instance().addDbLifecycleListener(this);
    }

    @Override
    public boolean onTrigger(ORecordHook.TYPE iType, ORecord<?> iRecord) {
        try {
            switch (iType) {
                case BEFORE_CREATE: 
                case BEFORE_UPDATE: 
                case BEFORE_DELETE: {
                    String clusterName = iRecord.getDatabase().getClusterNameById(iRecord.getIdentity().getClusterId());
                    if (this.manager.isCurrentNodeTheClusterOwner(iRecord.getDatabase().getName(), clusterName)) break;
                    ODocument servers = this.manager.getServersForCluster(iRecord.getDatabase().getName(), clusterName);
                    throw new ODistributedException("Can't apply changes to the cluster '" + clusterName + "' because the current node is not the owner for that record cluster. Please connect to the server: " + servers.field("owner"));
                }
                case AFTER_CREATE: {
                    this.manager.distributeRequest(new OTransactionRecordEntry((ORecordInternal)iRecord, 3, null));
                    break;
                }
                case AFTER_UPDATE: {
                    this.manager.distributeRequest(new OTransactionRecordEntry((ORecordInternal)iRecord, 1, null));
                    break;
                }
                case AFTER_DELETE: {
                    this.manager.distributeRequest(new OTransactionRecordEntry((ORecordInternal)iRecord, 2, null));
                }
            }
        }
        catch (IOException e) {
            throw new ODistributedSynchronizationException("Error on distribution of the record to the configured cluster", e);
        }
        return false;
    }

    @Override
    public void onOpen(ODatabase iDatabase) {
        ((ODatabaseComplex)iDatabase).registerHook(this);
    }

    @Override
    public void onClose(ODatabase iDatabase) {
        ((ODatabaseComplex)iDatabase).unregisterHook(this);
    }
}

