/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import java.util.HashMap;
import java.util.Map;

public class OHttpSession {
    private String id;
    private final long createdOn;
    private long lastUpdatedOn;
    private final String databaseName;
    private final String userName;
    private Map<Object, Object> parameters;

    protected OHttpSession(String iId, String iDatabaseName, String iUserName) {
        this.id = iId;
        this.lastUpdatedOn = this.createdOn = System.currentTimeMillis();
        this.databaseName = iDatabaseName;
        this.userName = iUserName;
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    public long getUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public OHttpSession updateLastUpdatedOn() {
        this.lastUpdatedOn = System.currentTimeMillis();
        return this;
    }

    public Object getParameters(Object iKey) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.entrySet();
    }

    public Object getParameter(Object iKey) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(iKey);
    }

    public OHttpSession setParameter(Object iKey, Object iValue) {
        if (this.parameters == null) {
            this.parameters = new HashMap<Object, Object>();
        }
        if (iValue == null) {
            this.parameters.remove(iKey);
        } else {
            this.parameters.put(iKey, iValue);
        }
        return this;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getId() {
        return this.id;
    }
}

