/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequestException;
import com.orientechnologies.orient.server.network.protocol.http.OHttpUtils;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;

public abstract class OServerCommandAbstract
implements OServerCommand {
    private static final String JSON_FORMAT = "type,indent:2,rid,version,attribSameRow,class";

    @Override
    public boolean beforeExecute(OHttpRequest iRequest) throws IOException {
        return true;
    }

    protected void sendTextContent(OHttpRequest iRequest, int iCode, String iReason, String iHeaders, String iContentType, Object iContent) throws IOException {
        this.sendTextContent(iRequest, iCode, iReason, iHeaders, iContentType, iContent, true);
    }

    protected void sendTextContent(OHttpRequest iRequest, int iCode, String iReason, String iHeaders, String iContentType, Object iContent, boolean iKeepAlive) throws IOException {
        String content = iContent != null ? iContent.toString() : null;
        boolean empty = content == null || content.length() == 0;
        this.sendStatus(iRequest, empty && iCode == 200 ? 204 : iCode, iReason);
        this.sendResponseHeaders(iRequest, iContentType, iKeepAlive);
        if (iHeaders != null) {
            this.writeLine(iRequest, iHeaders);
        }
        String sessId = iRequest.sessionId != null ? iRequest.sessionId : "-";
        this.writeLine(iRequest, "Set-Cookie: OSESSIONID=" + sessId + "; Path=/; HttpOnly");
        this.writeLine(iRequest, "Content-Length: " + (empty ? 0 : content.length()));
        this.writeLine(iRequest, null);
        if (!empty) {
            this.writeContent(iRequest, content);
        }
        iRequest.channel.flush();
    }

    protected void sendStatus(OHttpRequest iRequest, int iStatus, String iReason) throws IOException {
        this.writeLine(iRequest, iRequest.httpVersion + " " + iStatus + " " + iReason);
    }

    protected void sendResponseHeaders(OHttpRequest iRequest, String iContentType) throws IOException {
        this.sendResponseHeaders(iRequest, iContentType, true);
    }

    protected void sendResponseHeaders(OHttpRequest iRequest, String iContentType, boolean iKeepAlive) throws IOException {
        this.onBeforeResponseHeader(iRequest);
        this.writeLine(iRequest, "Date: " + new Date());
        this.writeLine(iRequest, "Content-Type: " + iContentType);
        this.writeLine(iRequest, "Server: " + iRequest.data.serverInfo);
        this.writeLine(iRequest, "Connection: " + (iKeepAlive ? "Keep-Alive" : "close"));
        this.onAfterResponseHeader(iRequest);
    }

    protected void onBeforeResponseHeader(OHttpRequest iRequest) throws IOException {
        this.writeLine(iRequest, "Cache-Control: no-cache, no-store, max-age=0, must-revalidate\r\nPragma: no-cache");
    }

    protected void onAfterResponseHeader(OHttpRequest iRequest) throws IOException {
    }

    protected void writeLine(OHttpRequest iRequest, String iContent) throws IOException {
        this.writeContent(iRequest, iContent);
        iRequest.channel.outStream.write(OHttpUtils.EOL);
    }

    protected void writeContent(OHttpRequest iRequest, String iContent) throws IOException {
        if (iContent != null) {
            iRequest.channel.outStream.write(OBinaryProtocol.string2bytes(iContent));
        }
    }

    protected String[] checkSyntax(String iURL, int iArgumentCount, String iSyntax) {
        String[] parts;
        int parametersPos = iURL.indexOf(63);
        if (parametersPos > -1) {
            iURL = iURL.substring(0, parametersPos);
        }
        if ((parts = iURL.substring(1).split("/")).length < iArgumentCount) {
            throw new OHttpRequestException(iSyntax);
        }
        return parts;
    }

    protected void sendRecordsContent(OHttpRequest iRequest, List<ORecord<?>> iRecords) throws IOException {
        this.sendRecordsContent(iRequest, iRecords, null);
    }

    protected void sendRecordsContent(OHttpRequest iRequest, List<ORecord<?>> iRecords, String iFetchPlan) throws IOException {
        ORecord<?> first;
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter(buffer, JSON_FORMAT);
        json.beginObject();
        if (iRecords != null && iRecords.size() > 0 && (first = iRecords.get(0)) != null && first instanceof ODocument) {
            ODatabaseRecord db = ((ODocument)first).getDatabase();
            String className = ((ODocument)first).getClassName();
            this.exportClassSchema(db, json, db.getMetadata().getSchema().getClass(className));
        }
        String format = iFetchPlan != null ? "type,indent:2,rid,version,attribSameRow,class,fetchPlan:" + iFetchPlan : JSON_FORMAT;
        json.beginCollection(1, true, "result");
        if (iRecords != null) {
            int counter = 0;
            for (ORecord<?> rec : iRecords) {
                if (rec == null) continue;
                try {
                    String objectJson = rec.toJSON(format);
                    if (counter++ > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(objectJson);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error transforming record " + rec.getIdentity() + " to JSON", (Throwable)e, new Object[0]);
                }
            }
        }
        json.endCollection(1, true);
        json.endObject();
        this.sendTextContent(iRequest, 200, "OK", null, "application/json", buffer.toString());
    }

    protected void sendRecordContent(OHttpRequest iRequest, ORecord<?> iRecord) throws IOException {
        this.sendRecordContent(iRequest, iRecord, null);
    }

    protected void sendRecordContent(OHttpRequest iRequest, ORecord<?> iRecord, String iFetchPlan) throws IOException {
        String format;
        String string = format = iFetchPlan != null ? "type,indent:2,rid,version,attribSameRow,class,fetchPlan:" + iFetchPlan : JSON_FORMAT;
        if (iRecord != null) {
            this.sendTextContent(iRequest, 200, "OK", null, "application/json", iRecord.toJSON(format));
        }
    }

    protected void sendBinaryContent(OHttpRequest iRequest, int iCode, String iReason, String iContentType, InputStream iContent, long iSize) throws IOException {
        this.sendStatus(iRequest, iCode, iReason);
        this.sendResponseHeaders(iRequest, iContentType);
        this.writeLine(iRequest, "Content-Length: " + iSize);
        this.writeLine(iRequest, null);
        while (iContent != null && iContent.available() > 0) {
            iRequest.channel.outStream.write((byte)iContent.read());
        }
        iRequest.channel.flush();
    }

    public void exportClassSchema(ODatabaseRecord db, OJSONWriter json, OClass cls) throws IOException {
        if (cls == null) {
            return;
        }
        json.write(" \"schema\": ");
        json.beginObject(1, false, null);
        json.writeAttribute(2, true, "name", cls.getName());
        if (cls.properties() != null && cls.properties().size() > 0) {
            json.beginObject(2, true, "properties");
            for (OProperty prop : cls.properties()) {
                json.beginObject(3, true, prop.getName());
                json.writeAttribute(4, true, "name", prop.getName());
                if (prop.getLinkedClass() != null) {
                    json.writeAttribute(4, true, "linkedClass", prop.getLinkedClass().getName());
                }
                if (prop.getLinkedType() != null) {
                    json.writeAttribute(4, true, "linkedType", prop.getLinkedType().toString());
                }
                json.writeAttribute(4, true, "type", prop.getType().toString());
                json.writeAttribute(4, true, "mandatory", prop.isMandatory());
                json.writeAttribute(4, true, "notNull", prop.isNotNull());
                json.writeAttribute(4, true, "min", prop.getMin());
                json.writeAttribute(4, true, "max", prop.getMax());
                json.endObject(3, true);
            }
            json.endObject(2, true);
        }
        json.endObject(1, true);
    }

    protected String nextChainUrl(String iCurrentUrl) {
        if (!iCurrentUrl.contains("/")) {
            return iCurrentUrl;
        }
        return iCurrentUrl.startsWith("/") ? iCurrentUrl.substring(iCurrentUrl.indexOf(47, 1)) : iCurrentUrl.substring(iCurrentUrl.indexOf("/"));
    }
}

