/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.delete;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandDeleteDocument
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"DELETE|document/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        ODatabaseDocumentTx db = null;
        try {
            String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: document/<database>/<record-id>");
            iRequest.data.commandInfo = "Delete document";
            db = this.getProfiledDatabaseInstance(iRequest);
            int parametersPos = urlParts[2].indexOf(63);
            String rid = parametersPos > -1 ? urlParts[2].substring(0, parametersPos) : urlParts[2];
            ORecordId recordId = new ORecordId(rid);
            if (!recordId.isValid()) {
                throw new IllegalArgumentException("Invalid Record ID in request: " + urlParts[2]);
            }
            ODocument doc = new ODocument((ODatabaseRecord)db, recordId);
            if (iRequest.content != null) {
                doc.fromJSON(iRequest.content);
            } else if (iRequest.ifMatch != null) {
                doc.setVersion(Integer.parseInt(iRequest.ifMatch));
            } else {
                doc.setVersion(-1);
            }
            doc.delete();
            this.sendTextContent(iRequest, 200, "OK", null, "text/plain", null);
            if (db == null) return false;
        }
        catch (Throwable throwable) {
            if (db == null) throw throwable;
            OSharedDocumentDatabase.release(db);
            throw throwable;
        }
        OSharedDocumentDatabase.release(db);
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

