/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.local.OTxSegment;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class OServerCommandGetConnect
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|connect/*"};

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: connect/<database>[/<user>/<password>]");
        urlParts[1] = urlParts[1].replace('$', '/');
        iRequest.data.commandInfo = "Connect";
        iRequest.data.commandDetail = urlParts[1];
        this.exec(iRequest, urlParts);
        return false;
    }

    @Override
    public boolean beforeExecute(OHttpRequest iRequest) throws IOException {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: connect/<database>[/<user>/<password>]");
        if (urlParts == null || urlParts.length < 3) {
            return super.beforeExecute(iRequest);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void exec(OHttpRequest iRequest, String[] urlParts) throws InterruptedException, IOException {
        ODatabaseDocumentTx db = null;
        try {
            db = urlParts.length > 2 ? OSharedDocumentDatabase.acquire(urlParts[1], urlParts[2], urlParts[3]) : this.getProfiledDatabaseInstance(iRequest);
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter(buffer);
            json.beginObject();
            if (db.getMetadata().getSchema().getClasses() != null) {
                json.beginCollection(1, false, "classes");
                HashSet<String> exportedNames = new HashSet<String>();
                for (OClass cls : db.getMetadata().getSchema().getClasses()) {
                    if (exportedNames.contains(cls.getName())) continue;
                    try {
                        this.exportClass(db, json, cls);
                        exportedNames.add(cls.getName());
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on exporting class '" + cls + "'", (Throwable)e, new Object[0]);
                    }
                }
                json.endCollection(1, true);
            }
            if (db.getStorage() instanceof OStorageLocal) {
                json.beginCollection(1, false, "dataSegments");
                for (ODataLocal data : ((OStorageLocal)db.getStorage()).getDataSegments()) {
                    json.beginObject(2, true, null);
                    json.writeAttribute(3, false, "id", data.getId());
                    json.writeAttribute(3, false, "name", data.getName());
                    json.writeAttribute(3, false, "size", data.getSize());
                    json.writeAttribute(3, false, "filled", data.getFilledUpTo());
                    json.writeAttribute(3, false, "maxSize", data.getConfig().maxSize);
                    json.writeAttribute(3, false, "files", Arrays.toString(data.getConfig().infoFiles));
                    json.endObject(2, false);
                }
                json.endCollection(1, true);
            }
            if (db.getClusterNames() != null) {
                json.beginCollection(1, false, "clusters");
                for (String clusterName : db.getClusterNames()) {
                    OCluster cluster = ((OStorageEmbedded)db.getStorage()).getClusterById(db.getClusterIdByName(clusterName));
                    try {
                        json.beginObject(2, true, null);
                        json.writeAttribute(3, false, "id", cluster.getId());
                        json.writeAttribute(3, false, "name", clusterName);
                        json.writeAttribute(3, false, "type", cluster.getType());
                        json.writeAttribute(3, false, "records", cluster.getEntries());
                        if (cluster instanceof OClusterLocal) {
                            json.writeAttribute(3, false, "size", ((OClusterLocal)cluster).getSize());
                            json.writeAttribute(3, false, "filled", ((OClusterLocal)cluster).getFilledUpTo());
                            json.writeAttribute(3, false, "maxSize", ((OClusterLocal)cluster).getConfig().maxSize);
                            json.writeAttribute(3, false, "files", Arrays.toString(((OClusterLocal)cluster).getConfig().infoFiles));
                        } else {
                            json.writeAttribute(3, false, "size", "-");
                            json.writeAttribute(3, false, "filled", "-");
                            json.writeAttribute(3, false, "maxSize", "-");
                            json.writeAttribute(3, false, "files", "-");
                        }
                    }
                    catch (Exception e) {
                        json.writeAttribute(3, false, "records", "? (Unauthorized)");
                    }
                    json.endObject(2, false);
                }
                json.endCollection(1, true);
            }
            if (db.getStorage() instanceof OStorageLocal) {
                json.beginCollection(1, false, "txSegment");
                OTxSegment txSegment = ((OStorageLocal)db.getStorage()).getTxManager().getTxSegment();
                json.beginObject(2, true, null);
                json.writeAttribute(3, false, "totalLogs", txSegment.getTotalLogCount());
                json.writeAttribute(3, false, "size", txSegment.getSize());
                json.writeAttribute(3, false, "filled", txSegment.getFilledUpTo());
                json.writeAttribute(3, false, "maxSize", txSegment.getConfig().maxSize);
                json.writeAttribute(3, false, "file", txSegment.getConfig().path);
                json.endObject(2, false);
                json.endCollection(1, true);
            }
            json.beginCollection(1, false, "users");
            for (ODocument doc : db.getMetadata().getSecurity().getUsers()) {
                OUser user = new OUser(doc);
                json.beginObject(2, true, null);
                json.writeAttribute(3, false, "name", user.getName());
                json.writeAttribute(3, false, "roles", user.getRoles() != null ? Arrays.toString(user.getRoles().toArray()) : "null");
                json.endObject(2, false);
            }
            json.endCollection(1, true);
            json.beginCollection(1, true, "roles");
            for (ODocument doc : db.getMetadata().getSecurity().getRoles()) {
                ORole role = new ORole(doc);
                json.beginObject(2, true, null);
                json.writeAttribute(3, false, "name", role.getName());
                json.writeAttribute(3, false, "mode", role.getMode().toString());
                json.beginCollection(3, true, "rules");
                for (Map.Entry<String, Byte> rule : role.getRules().entrySet()) {
                    json.beginObject(4);
                    json.writeAttribute(4, true, "name", rule.getKey());
                    json.writeAttribute(4, false, "create", role.allow(rule.getKey(), 1));
                    json.writeAttribute(4, false, "read", role.allow(rule.getKey(), 2));
                    json.writeAttribute(4, false, "update", role.allow(rule.getKey(), 4));
                    json.writeAttribute(4, false, "delete", role.allow(rule.getKey(), 8));
                    json.endObject(4, true);
                }
                json.endCollection(3, false);
                json.endObject(2, true);
            }
            json.endCollection(1, true);
            json.beginObject(1, true, "config");
            json.beginCollection(2, true, "values");
            json.writeObjects(3, true, null, {"name", "dateFormat", "value", db.getStorage().getConfiguration().dateFormat}, {"name", "dateTimeFormat", "value", db.getStorage().getConfiguration().dateTimeFormat}, {"name", "localeCountry", "value", db.getStorage().getConfiguration().localeCountry}, {"name", "localeLanguage", "value", db.getStorage().getConfiguration().localeLanguage}, {"name", "definitionVersion", "value", db.getStorage().getConfiguration().version});
            json.endCollection(2, true);
            json.beginCollection(2, true, "properties");
            if (db.getStorage().getConfiguration().properties != null) {
                for (OStorageEntryConfiguration entry : db.getStorage().getConfiguration().properties) {
                    if (entry == null) continue;
                    json.beginObject(3, true, null);
                    json.writeAttribute(4, false, "name", entry.name);
                    json.writeAttribute(4, false, "value", entry.value);
                    json.endObject(3, true);
                }
            }
            json.endCollection(2, true);
            json.endObject(1, true);
            json.endObject();
            json.flush();
            this.sendTextContent(iRequest, 200, "OK", null, "application/json", buffer.toString());
            if (db == null) return;
        }
        catch (Throwable throwable) {
            if (db == null) throw throwable;
            OSharedDocumentDatabase.release(db);
            throw throwable;
        }
        OSharedDocumentDatabase.release(db);
    }

    public void exportClass(ODatabaseDocumentTx db, OJSONWriter json, OClass cls) throws IOException {
        json.beginObject(2, true, null);
        json.writeAttribute(3, true, "name", cls.getName());
        json.writeAttribute(3, true, "superClass", cls.getSuperClass() != null ? cls.getSuperClass().getName() : "");
        json.writeAttribute(3, true, "alias", cls.getShortName());
        json.writeAttribute(3, true, "clusters", cls.getClusterIds());
        json.writeAttribute(3, true, "defaultCluster", cls.getDefaultClusterId());
        try {
            json.writeAttribute(3, false, "records", db.countClass(cls.getName()));
        }
        catch (OSecurityAccessException e) {
            json.writeAttribute(3, false, "records", "? (Unauthorized)");
        }
        if (cls.properties() != null && cls.properties().size() > 0) {
            json.beginCollection(3, true, "properties");
            for (OProperty prop : cls.properties()) {
                json.beginObject(4, true, null);
                json.writeAttribute(4, true, "name", prop.getName());
                if (prop.getLinkedClass() != null) {
                    json.writeAttribute(4, true, "linkedClass", prop.getLinkedClass().getName());
                }
                if (prop.getLinkedType() != null) {
                    json.writeAttribute(4, true, "linkedType", prop.getLinkedType().toString());
                }
                json.writeAttribute(4, true, "type", prop.getType().toString());
                json.writeAttribute(4, true, "mandatory", prop.isMandatory());
                json.writeAttribute(4, true, "notNull", prop.isNotNull());
                json.writeAttribute(4, true, "min", prop.getMin());
                json.writeAttribute(4, true, "max", prop.getMax());
                json.writeAttribute(4, true, "indexed", prop.isIndexed());
                json.endObject(3, true);
            }
            json.endCollection(1, true);
        }
        json.endObject(1, false);
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

