/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.util.Date;

public class OServerCommandGetFileDownload
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|fileDownload/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String fileName;
        ODatabaseDocumentTx db = this.getProfiledDatabaseInstance(iRequest);
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: fileDownload/<database>/rid/[/<fileName>][/<fileType>].");
        String string = fileName = urlParts.length > 3 ? this.encodeResponseText(urlParts[3]) : "unknown";
        String fileType = urlParts.length > 5 ? this.encodeResponseText(urlParts[4]) + '/' + this.encodeResponseText(urlParts[5]) : (urlParts.length > 4 ? this.encodeResponseText(urlParts[4]) : "");
        String rid = urlParts[2];
        iRequest.data.commandInfo = "Download";
        iRequest.data.commandDetail = rid;
        try {
            ORecordBytes response = (ORecordBytes)db.load(new ORecordId(rid));
            if (response != null) {
                this.sendBinaryFileContent(iRequest, 200, "OK", fileType, response, fileName);
            } else {
                this.sendTextContent(iRequest, 405, "Record requested not exists", null, "text/plain", "Record requestes not exists");
            }
        }
        catch (Exception e) {
            this.sendTextContent(iRequest, 500, "Internal Server Error", null, "text/plain", e.getMessage());
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        return false;
    }

    protected void sendBinaryFileContent(OHttpRequest iRequest, int iCode, String iReason, String iContentType, ORecordBytes record, String iFileName) throws IOException {
        this.sendStatus(iRequest, iCode, iReason);
        this.sendResponseHeaders(iRequest, iContentType);
        this.writeLine(iRequest, "Content-Disposition: attachment; filename=" + iFileName);
        this.writeLine(iRequest, "Date: " + new Date());
        this.writeLine(iRequest, "Content-Length: " + record.getSize());
        this.writeLine(iRequest, null);
        record.toOutputStream(iRequest.channel.outStream);
        iRequest.channel.flush();
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    private String encodeResponseText(String iText) {
        iText = new String(iText.replaceAll(" ", "%20"));
        iText = new String(iText.replaceAll("&", "%26"));
        return iText;
    }
}

