/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OStaticContentCachedEntry;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class OServerCommandGetStaticContent
extends OServerCommandAbstract {
    private static final String[] DEF_PATTERN = new String[]{"GET|www", "GET|studio/", "GET|", "GET|*.htm", "GET|*.html", "GET|*.xml", "GET|*.jpeg", "GET|*.jpg", "GET|*.png", "GET|*.gif", "GET|*.js", "GET|*.css", "GET|*.swf", "GET|favicon.ico", "GET|robots.txt"};
    private static final String CONFIG_HTTP_CACHE = "http.cache:";
    private Map<String, OStaticContentCachedEntry> cacheContents;
    private Map<String, String> cacheHttp = new HashMap<String, String>();
    private String cacheHttpDefault = "Cache-Control: max-age=3000";
    private String wwwPath;
    private final String[] pattern;

    public OServerCommandGetStaticContent() {
        this.pattern = DEF_PATTERN;
    }

    public OServerCommandGetStaticContent(OServerCommandConfiguration iConfiguration) {
        this.pattern = iConfiguration.pattern.split(" ");
        for (OServerEntryConfiguration par : iConfiguration.parameters) {
            String[] filters;
            if (!par.name.startsWith(CONFIG_HTTP_CACHE)) continue;
            String filter = par.name.substring(CONFIG_HTTP_CACHE.length());
            if (filter.equalsIgnoreCase("default")) {
                this.cacheHttpDefault = par.value;
                continue;
            }
            if (filter.length() <= 0) continue;
            for (String f : filters = filter.split(" ")) {
                this.cacheHttp.put(f, par.value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        iRequest.data.commandInfo = "Get static content";
        iRequest.data.commandDetail = iRequest.url;
        if (this.wwwPath == null) {
            this.wwwPath = iRequest.configuration.getValueAsString("orientdb.www.path", "src/site");
        }
        if (this.cacheContents == null && OGlobalConfiguration.SERVER_CACHE_FILE_STATIC.getValueAsBoolean()) {
            this.cacheContents = new HashMap<String, OStaticContentCachedEntry>();
        }
        InputStream is = null;
        long contentSize = 0L;
        String type = null;
        try {
            String url = this.getResource(iRequest);
            String filePath = url.startsWith("/www") ? this.wwwPath + url.substring("/www".length(), url.length()) : this.wwwPath + url;
            if (this.cacheContents != null) {
                Map<String, OStaticContentCachedEntry> map = this.cacheContents;
                synchronized (map) {
                    OStaticContentCachedEntry cachedEntry = this.cacheContents.get(filePath);
                    if (cachedEntry != null) {
                        is = new ByteArrayInputStream(cachedEntry.content);
                        contentSize = cachedEntry.size;
                        type = cachedEntry.type;
                    }
                }
            }
            if (is == null) {
                File inputFile = new File(filePath);
                if (!inputFile.exists()) {
                    OLogManager.instance().debug((Object)this, "Static resource not found: %s", new Object[]{filePath});
                    this.sendBinaryContent(iRequest, 404, "File not found", null, null, 0L);
                    boolean cachedEntry = false;
                    return cachedEntry;
                }
                if (inputFile.isDirectory()) {
                    inputFile = new File(filePath + "/index.htm");
                    if (inputFile.exists()) {
                        filePath = url + "/index.htm";
                    } else {
                        inputFile = new File(url + "/index.html");
                        if (inputFile.exists()) {
                            filePath = url + "/index.html";
                        }
                    }
                }
                if (url.endsWith(".htm") || url.endsWith(".html")) {
                    type = "text/html";
                } else if (url.endsWith(".png")) {
                    type = "image/png";
                } else if (url.endsWith(".jpeg")) {
                    type = "image/jpeg";
                } else if (url.endsWith(".js")) {
                    type = "application/x-javascript";
                } else if (url.endsWith(".css")) {
                    type = "text/css";
                }
                is = new BufferedInputStream(new FileInputStream(inputFile));
                contentSize = inputFile.length();
                if (this.cacheContents != null) {
                    byte[] buffer = new byte[(int)contentSize];
                    int i = 0;
                    while ((long)i < contentSize) {
                        buffer[i] = (byte)is.read();
                        ++i;
                    }
                    OStaticContentCachedEntry cachedEntry = new OStaticContentCachedEntry();
                    cachedEntry.content = buffer;
                    cachedEntry.size = contentSize;
                    cachedEntry.type = type;
                    this.cacheContents.put(url, cachedEntry);
                    is = new ByteArrayInputStream(cachedEntry.content);
                }
            }
            this.sendBinaryContent(iRequest, 200, "OK", type, is, contentSize);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return this.pattern;
    }

    @Override
    protected void onBeforeResponseHeader(OHttpRequest iRequest) throws IOException {
        String header = this.cacheHttpDefault;
        if (this.cacheHttp.size() > 0) {
            String resource = this.getResource(iRequest);
            for (Map.Entry<String, String> entry : this.cacheHttp.entrySet()) {
                int wildcardPos = entry.getKey().indexOf(42);
                String partLeft = entry.getKey().substring(0, wildcardPos);
                String partRight = entry.getKey().substring(wildcardPos + 1);
                if (!resource.startsWith(partLeft) || !resource.endsWith(partRight)) continue;
                header = entry.getValue();
                break;
            }
        }
        this.writeLine(iRequest, header);
    }

    protected String getResource(OHttpRequest iRequest) {
        int pos;
        String url = "/".equals(iRequest.url) ? "/www/index.htm" : ((pos = iRequest.url.indexOf(63)) > -1 ? iRequest.url.substring(0, pos) : iRequest.url);
        return url;
    }
}

