/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.ODatabaseRecordWrapperAbstract;
import com.orientechnologies.orient.core.db.ODatabaseWrapperAbstract;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;

public class OServerCommandPostDatabase
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"POST|database/*"};

    public OServerCommandPostDatabase() {
        super("new-database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: database/<database>");
        iRequest.data.commandInfo = "Create database";
        iRequest.data.commandDetail = urlParts[1];
        ODatabaseWrapperAbstract db = null;
        try {
            if (OSharedDocumentDatabase.getDatabasePools().containsKey(urlParts[1])) {
                throw new IllegalArgumentException("Can't create the database '" + urlParts[1] + "' because it already exists");
            }
            db = new ODatabaseDocumentTx("local:${ORIENTDB_HOME}/databases/" + urlParts[1] + "/" + urlParts[1]);
            ((ODatabaseRecordWrapperAbstract)db).create();
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        this.sendTextContent(iRequest, 200, "OK", null, "text/plain", null);
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

