/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandPostProperty
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"POST|property/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: property/<database>/<class-name>/<property-name>");
        iRequest.data.commandInfo = "Create property";
        iRequest.data.commandDetail = urlParts[2] + "." + urlParts[3];
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getMetadata().getSchema().getClass(urlParts[2]) == null) {
                throw new IllegalArgumentException("Invalid class '" + urlParts[2] + "'");
            }
            OClass cls = db.getMetadata().getSchema().getClass(urlParts[2]);
            OProperty prop = cls.createProperty(urlParts[3], OType.STRING);
            this.sendTextContent(iRequest, 201, "Created", null, "text/plain", cls.properties().size());
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

