/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OServerCommandPostStudio
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"POST|studio/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        ODatabaseDocumentTx db = null;
        try {
            String[] params;
            String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: studio/<database>/<context>");
            db = this.getProfiledDatabaseInstance(iRequest);
            String req = iRequest.content;
            String operation = null;
            String rid = null;
            String className = null;
            HashMap<String, String> fields = new HashMap<String, String>();
            for (String p : params = req.split("&")) {
                String value;
                String[] pairs = p.split("=");
                String string = value = pairs.length == 1 ? null : pairs[1];
                if ("oper".equals(pairs[0])) {
                    operation = value;
                    continue;
                }
                if ("0".equals(pairs[0])) {
                    rid = value;
                    continue;
                }
                if ("1".equals(pairs[0])) {
                    className = value;
                    continue;
                }
                if (pairs[0].startsWith("@class")) {
                    className = value;
                    continue;
                }
                if (pairs[0].startsWith("@") || pairs[0].equals("id")) continue;
                fields.put(pairs[0], value);
            }
            String context = urlParts[2];
            if ("document".equals(context)) {
                this.executeDocument(iRequest, db, operation, rid, className, fields);
            } else if ("classes".equals(context)) {
                this.executeClasses(iRequest, db, operation, rid, className, fields);
            } else if ("clusters".equals(context)) {
                this.executeClusters(iRequest, db, operation, rid, className, fields);
            } else if ("classProperties".equals(context)) {
                this.executeClassProperties(iRequest, db, operation, rid, className, fields);
            }
            if (db == null) return false;
        }
        catch (Throwable throwable) {
            if (db == null) throw throwable;
            OSharedDocumentDatabase.release(db);
            throw throwable;
        }
        OSharedDocumentDatabase.release(db);
        return false;
    }

    private void executeClassProperties(OHttpRequest iRequest, ODatabaseDocumentTx db, String operation, String rid, String className, Map<String, String> fields) throws IOException {
        OClass cls = db.getMetadata().getSchema().getClass(rid);
        if (cls == null) {
            this.sendTextContent(iRequest, 500, "Error", null, "text/plain", "Error: Class '" + rid + "' not found.");
            return;
        }
        if ("add".equals(operation)) {
            iRequest.data.commandInfo = "Studio add property";
            try {
                OType type = OType.valueOf(fields.get("type"));
                OPropertyImpl prop = type == OType.LINK || type == OType.LINKLIST || type == OType.LINKSET || type == OType.LINKMAP ? (OPropertyImpl)cls.createProperty(fields.get("name"), type, db.getMetadata().getSchema().getClass(fields.get("linkedClass"))) : (OPropertyImpl)cls.createProperty(fields.get("name"), type);
                if (fields.get("linkedType") != null) {
                    prop.setLinkedType(OType.valueOf(fields.get("linkedType")));
                }
                if (fields.get("mandatory") != null) {
                    prop.setMandatory("on".equals(fields.get("mandatory")));
                }
                if (fields.get("notNull") != null) {
                    prop.setNotNull("on".equals(fields.get("notNull")));
                }
                if (fields.get("min") != null) {
                    prop.setMin(fields.get("min"));
                }
                if (fields.get("max") != null) {
                    prop.setMax(fields.get("max"));
                }
                if (fields.get("indexed") != null) {
                    prop.createIndex(fields.get("indexed").equals("Unique") ? OProperty.INDEX_TYPE.UNIQUE : OProperty.INDEX_TYPE.NOTUNIQUE);
                }
                this.sendTextContent(iRequest, 200, "OK", null, "text/plain", "Property " + fields.get("name") + " created successfully");
            }
            catch (Exception e) {
                this.sendTextContent(iRequest, 500, "Error on creating a new property in class " + rid + ": " + e, null, "text/plain", "Error on creating a new property in class " + rid + ": " + e);
            }
        } else if ("del".equals(operation)) {
            iRequest.data.commandInfo = "Studio delete property";
            cls.dropProperty(className);
            this.sendTextContent(iRequest, 200, "OK", null, "text/plain", "Property " + fields.get("name") + " deleted successfully.");
        }
    }

    private void executeClasses(OHttpRequest iRequest, ODatabaseDocumentTx db, String operation, String rid, String className, Map<String, String> fields) throws IOException {
        if ("add".equals(operation)) {
            iRequest.data.commandInfo = "Studio add class";
            try {
                String superClassName = fields.get("superClass");
                OClass superClass = superClassName != null ? db.getMetadata().getSchema().getClass(superClassName) : null;
                OClass cls = db.getMetadata().getSchema().createClass(fields.get("name"), superClass);
                String alias = fields.get("alias");
                if (alias != null) {
                    cls.setShortName(alias);
                }
                this.sendTextContent(iRequest, 200, "OK", null, "text/plain", "Class '" + rid + "' created successfully with id=" + db.getMetadata().getSchema().getClasses().size());
            }
            catch (Exception e) {
                this.sendTextContent(iRequest, 500, "Error on creating the new class '" + rid + "': " + e, null, "text/plain", "Error on creating the new class '" + rid + "': " + e);
            }
        } else if ("del".equals(operation)) {
            iRequest.data.commandInfo = "Studio delete class";
            db.getMetadata().getSchema().dropClass(rid);
            this.sendTextContent(iRequest, 200, "OK", null, "text/plain", "Class '" + rid + "' deleted successfully.");
        }
    }

    private void executeClusters(OHttpRequest iRequest, ODatabaseDocumentTx db, String operation, String rid, String iClusterName, Map<String, String> fields) throws IOException {
        if ("add".equals(operation)) {
            iRequest.data.commandInfo = "Studio add cluster";
        } else if ("del".equals(operation)) {
            iRequest.data.commandInfo = "Studio delete cluster";
        }
    }

    private void executeDocument(OHttpRequest iRequest, ODatabaseDocumentTx db, String operation, String rid, String className, Map<String, String> fields) throws IOException {
        if ("edit".equals(operation)) {
            iRequest.data.commandInfo = "Studio edit document";
            if (rid == null) {
                throw new IllegalArgumentException("Record ID not found in request");
            }
            ODocument doc = new ODocument(db, className, new ORecordId(rid));
            doc = (ODocument)doc.load();
            for (Map.Entry<String, String> f : fields.entrySet()) {
                Object oldValue = doc.field(f.getKey());
                Object newValue = f.getValue();
                if (oldValue != null) {
                    if (oldValue instanceof ORecord) {
                        ORecord rec = (ORecord)oldValue;
                        String parsedRid = f.getValue();
                        if (parsedRid != null && parsedRid.charAt(0) == '#') {
                            parsedRid = parsedRid.substring(1);
                        }
                        if (!rec.getIdentity().toString().equals(parsedRid)) {
                            rec.reset();
                            ((ORecordId)rec.getIdentity()).fromString(parsedRid);
                            rec.load();
                        }
                        newValue = oldValue;
                    } else if (oldValue instanceof Collection) {
                        newValue = new ArrayList();
                        if (f.getValue() != null) {
                            String[] items;
                            for (String s : items = f.getValue().split(",")) {
                                ((List)newValue).add(new ODocument((ODatabaseRecord)db, new ORecordId(s)));
                            }
                        }
                    }
                }
                doc.field(f.getKey(), newValue);
            }
            doc.save();
            this.sendTextContent(iRequest, 200, "OK", null, "text/plain", "Record " + rid + " updated successfully.");
        } else if ("add".equals(operation)) {
            iRequest.data.commandInfo = "Studio create document";
            ODocument doc = new ODocument((ODatabaseRecord)db, className);
            for (Map.Entry<String, String> f : fields.entrySet()) {
                doc.field(f.getKey(), f.getValue());
            }
            doc.save();
            this.sendTextContent(iRequest, 201, "OK", null, "text/plain", "Record " + doc.getIdentity() + " updated successfully.");
        } else if ("del".equals(operation)) {
            iRequest.data.commandInfo = "Studio delete document";
            if (rid == null) {
                throw new IllegalArgumentException("Record ID not found in request");
            }
            ODocument doc = new ODocument((ODatabaseRecord)db, new ORecordId(rid));
            doc.load();
            doc.delete();
            this.sendTextContent(iRequest, 200, "OK", null, "text/plain", "Record " + rid + " deleted successfully.");
        } else {
            this.sendTextContent(iRequest, 500, "Error", null, "text/plain", "Operation not supported");
        }
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

