/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.put;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandPutIndex
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"PUT|index/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: index/<database>/<index-name>/<key>[/<value>]");
        iRequest.data.commandInfo = "Index put";
        ODatabaseDocumentTx db = null;
        try {
            ORecordId record;
            db = this.getProfiledDatabaseInstance(iRequest);
            OIndex<?> index = db.getMetadata().getIndexManager().getIndex(urlParts[2]);
            if (index == null) {
                throw new IllegalArgumentException("Index name '" + urlParts[2] + "' not found");
            }
            if (urlParts.length > 4) {
                record = new ORecordId(urlParts[4]);
            } else {
                if (iRequest.content == null || iRequest.content.length() == 0) {
                    throw new IllegalArgumentException("Index's entry value is null");
                }
                record = new ODocument(db).fromJSON(iRequest.content);
            }
            index.put(urlParts[3], record);
            this.sendTextContent(iRequest, 200, "OK", null, "text/plain", "Key '" + urlParts[3] + "' correctly inserted into the index " + urlParts[2] + ".");
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

