/*
 * Decompiled with CFR 0.152.
 */
package play.modules.orientdb;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.object.ODatabaseObjectTx;
import play.inject.BeanSource;
import play.modules.orientdb.ODB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseSource
implements BeanSource {
    private final ODatabaseDocumentTx documentDB;
    private final ODatabaseObjectTx objectDB;
    private final OGraphDatabase graphDB;

    public DatabaseSource(int conf) {
        this.documentDB = this.isEnabled(conf, 1) ? ODB.openDocumentDB() : null;
        this.objectDB = this.isEnabled(conf, 2) ? ODB.openObjectDB() : null;
        this.graphDB = this.isEnabled(conf, 4) ? ODB.openGraphDB() : null;
    }

    public <T> T getBeanOfType(Class<T> clazz) {
        if (ODatabaseObjectTx.class.isAssignableFrom(clazz)) {
            return (T)this.objectDB;
        }
        if (ODatabaseDocumentTx.class.isAssignableFrom(clazz)) {
            return (T)this.documentDB;
        }
        if (OGraphDatabase.class.isAssignableFrom(clazz)) {
            return (T)this.graphDB;
        }
        return null;
    }

    private boolean isEnabled(int conf, int property) {
        return (conf & property) == property;
    }
}

