/*
 * Decompiled with CFR 0.152.
 */
package play.modules.orientdb;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.graph.OGraphDatabasePool;
import com.orientechnologies.orient.core.db.object.ODatabaseObjectPool;
import com.orientechnologies.orient.core.db.object.ODatabaseObjectTx;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.util.ArrayList;
import java.util.List;
import play.classloading.ApplicationClasses;
import play.exceptions.UnexpectedException;
import play.modules.orientdb.ODBPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODB {
    public static final List<ApplicationClasses.ApplicationClass> listeners = new ArrayList<ApplicationClasses.ApplicationClass>();
    public static final List<ApplicationClasses.ApplicationClass> hooks = new ArrayList<ApplicationClasses.ApplicationClass>();
    static final ThreadLocal<ODatabaseObjectTx> localObjectTx = new ThreadLocal();
    static final ThreadLocal<ODatabaseDocumentTx> localDocumentTx = new ThreadLocal();
    static final ThreadLocal<OGraphDatabase> localGraphTx = new ThreadLocal();

    public static void begin(OTransaction.TXTYPE type, DBTYPE db) {
        if (db == DBTYPE.DOCUMENT) {
            ODB.openDocumentDB().begin(type);
        } else {
            ODB.openObjectDB().begin(type);
        }
    }

    public static void close() {
        ODB.closeDocument();
        ODB.closeObject();
        ODB.closeGraph();
    }

    public static void closeDocument() {
        if (ODB.hasDocumentTx()) {
            localDocumentTx.get().close();
            localDocumentTx.set(null);
        }
    }

    public static void closeGraph() {
        if (ODB.hasGraphTx()) {
            localGraphTx.get().close();
            localGraphTx.set(null);
        }
    }

    public static void closeObject() {
        if (ODB.hasObjectTx()) {
            localObjectTx.get().close();
            localObjectTx.set(null);
        }
    }

    public static void commit() {
        if (ODB.hasObjectTx() && localObjectTx.get().getTransaction().isActive()) {
            localObjectTx.get().commit();
        }
        if (ODB.hasDocumentTx() && localDocumentTx.get().getTransaction().isActive()) {
            localDocumentTx.get().commit();
        }
    }

    public static ODatabaseDocumentTx openDocumentDB() {
        if (!ODB.hasDocumentTx()) {
            ODatabaseDocumentTx db = (ODatabaseDocumentTx)ODatabaseDocumentPool.global().acquire(ODBPlugin.url, ODBPlugin.user, ODBPlugin.passwd);
            localDocumentTx.set(db);
            ODB.registerListeners((ODatabase)db);
        }
        return localDocumentTx.get();
    }

    public static OGraphDatabase openGraphDB() {
        if (!ODB.hasGraphTx()) {
            OGraphDatabase db = (OGraphDatabase)OGraphDatabasePool.global().acquire(ODBPlugin.gurl == null ? ODBPlugin.url : ODBPlugin.gurl, ODBPlugin.user, ODBPlugin.passwd);
            localGraphTx.set(db);
            ODB.registerListeners((ODatabase)db);
        }
        return localGraphTx.get();
    }

    public static ODatabaseObjectTx openObjectDB() {
        if (!ODB.hasObjectTx()) {
            ODatabaseObjectTx db = (ODatabaseObjectTx)ODatabaseObjectPool.global().acquire(ODBPlugin.url, ODBPlugin.user, ODBPlugin.passwd);
            localObjectTx.set(db);
            ODB.registerListeners((ODatabase)db);
            ODB.registerHooks(db);
        }
        return localObjectTx.get();
    }

    public static void rollback() {
        if (ODB.hasObjectTx() && localObjectTx.get().getTransaction().isActive()) {
            localObjectTx.get().rollback();
        }
        if (ODB.hasDocumentTx() && localDocumentTx.get().getTransaction().isActive()) {
            localDocumentTx.get().rollback();
        }
    }

    private static boolean hasDocumentTx() {
        return localDocumentTx.get() != null;
    }

    private static boolean hasGraphTx() {
        return localGraphTx.get() != null;
    }

    private static boolean hasObjectTx() {
        return localObjectTx.get() != null;
    }

    private static <T> T newInstance(ApplicationClasses.ApplicationClass appClass) {
        try {
            return appClass.javaClass.newInstance();
        }
        catch (IllegalArgumentException e) {
            throw new UnexpectedException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new UnexpectedException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new UnexpectedException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    private static void registerHooks(ODatabaseObjectTx db) {
        for (ApplicationClasses.ApplicationClass hook : hooks) {
            db.registerHook((ORecordHook)ODB.newInstance(hook));
        }
    }

    private static void registerListeners(ODatabase db) {
        for (ApplicationClasses.ApplicationClass listener : listeners) {
            db.registerListener((ODatabaseListener)ODB.newInstance(listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBTYPE {
        DOCUMENT,
        OBJECT;

    }
}

