/*
 * Decompiled with CFR 0.152.
 */
package play.modules.orientdb;

import com.orientechnologies.orient.core.annotation.OId;
import com.orientechnologies.orient.core.annotation.OVersion;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.object.ODatabaseObjectTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OObjectIteratorMultiCluster;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.Id;
import javax.persistence.Transient;
import javax.persistence.Version;
import play.Logger;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.modules.orientdb.ODB;
import play.modules.orientdb.OSQLSynchPaginatedQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OModelLoader
implements Model.Factory {
    private final Class<? extends Model> clazz;

    public OModelLoader(Class<? extends Model> modelClass) {
        this.clazz = modelClass;
    }

    public Long count(List<String> searchFields, String keywords, String where) {
        ODatabaseObjectTx db = ODB.openObjectDB();
        String q = "select count(*) from " + this.clazz.getSimpleName() + " ";
        ArrayList<Object> params = new ArrayList<Object>();
        if (keywords != null && !keywords.equals("")) {
            String searchQuery = this.getSearchQuery(searchFields, params, keywords);
            if (!searchQuery.equals("")) {
                q = q + " where ( " + searchQuery + " )";
            }
            q = q + (where != null ? " and " + where : "");
        } else {
            q = q + (where != null ? " where " + where : "");
        }
        Long count = 0L;
        try {
            List lcount = db.query((OQuery)new OSQLSynchQuery(q), params.toArray());
            if (lcount != null && !lcount.isEmpty()) {
                ODocument doc = (ODocument)lcount.get(0);
                count = (Long)doc.field("count");
            }
        }
        catch (Exception e) {
            Logger.warn((String)e.getMessage(), (Object[])new Object[]{e});
        }
        return count;
    }

    public void deleteAll() {
        ODatabaseObjectTx db = ODB.openObjectDB();
        db.command((OCommandRequest)new OCommandSQL("delete from " + this.clazz.getSimpleName())).execute(new Object[0]);
    }

    public List<Model> fetch(int offset, int size, String orderBy, String order, List<String> searchFields, String keywords, String where) {
        String q = "select from " + this.clazz.getSimpleName();
        ArrayList<Object> params = new ArrayList<Object>();
        if (keywords != null && !keywords.equals("")) {
            String searchQuery = this.getSearchQuery(searchFields, params, keywords);
            if (!searchQuery.equals("")) {
                q = q + " where ( " + searchQuery + " )";
            }
            q = q + (where != null ? " and " + where : "");
        } else {
            q = q + (where != null ? " where " + where : "");
        }
        if (orderBy == null && order == null) {
            orderBy = "id";
            order = "ASC";
        }
        if (orderBy == null && order != null) {
            orderBy = "id";
        }
        if (order == null || !order.equals("ASC") && !order.equals("DESC")) {
            order = "ASC";
        }
        q = q + " order by " + orderBy + " " + order;
        OSQLSynchPaginatedQuery query = new OSQLSynchPaginatedQuery(q, offset, size);
        List result = ODB.openObjectDB().query(query, params.toArray());
        return result;
    }

    public Model findById(Object id) {
        if (id == null) {
            return null;
        }
        if (id instanceof String) {
            id = new ORecordId((String)id);
        } else if (!ORID.class.isAssignableFrom(id.getClass())) {
            throw new UnexpectedException("Please use Object or String for your ids");
        }
        return (Model)ODB.openObjectDB().load((ORID)id);
    }

    public String keyName() {
        return this.keyField().getName();
    }

    public Class<?> keyType() {
        return this.keyField().getType();
    }

    public Object keyValue(Model m) {
        try {
            return this.keyField().get(m);
        }
        catch (Exception ex) {
            throw new UnexpectedException((Throwable)ex);
        }
    }

    public List<Model.Property> listProperties() {
        ArrayList<Model.Property> properties = new ArrayList<Model.Property>();
        LinkedHashSet fields = new LinkedHashSet();
        Class<? extends Model> tclazz = this.clazz;
        while (!tclazz.equals(Object.class)) {
            Collections.addAll(fields, tclazz.getDeclaredFields());
            tclazz = tclazz.getSuperclass();
        }
        for (Field f : fields) {
            Model.Property mp;
            if (Modifier.isTransient(f.getModifiers()) || f.isAnnotationPresent(Transient.class) || (mp = this.buildProperty(f)) == null) continue;
            properties.add(mp);
        }
        return properties;
    }

    Model.Property buildProperty(final Field field) {
        Class fieldType;
        Model.Property modelProperty = new Model.Property();
        modelProperty.type = field.getType();
        modelProperty.field = field;
        if (Model.class.isAssignableFrom(field.getType())) {
            modelProperty.isRelation = true;
            modelProperty.relationType = field.getType();
            modelProperty.choices = new Model.Choices(){

                public List<Object> list() {
                    return OModelLoader.this.toList((OObjectIteratorMultiCluster<Object>)ODB.openObjectDB().browseClass(field.getType()));
                }
            };
        }
        if (Collection.class.isAssignableFrom(field.getType()) && Model.class.isAssignableFrom(fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0])) {
            modelProperty.isRelation = true;
            modelProperty.isMultiple = true;
            modelProperty.relationType = fieldType;
            modelProperty.choices = new Model.Choices(){

                public List<Object> list() {
                    return OModelLoader.this.toList((OObjectIteratorMultiCluster<Object>)ODB.openObjectDB().browseClass(fieldType));
                }
            };
        }
        if (field.getType().isEnum()) {
            modelProperty.choices = new Model.Choices(){

                public List<Object> list() {
                    return Arrays.asList(field.getType().getEnumConstants());
                }
            };
        }
        modelProperty.name = field.getName();
        if (field.getType().equals(String.class)) {
            modelProperty.isSearchable = true;
        }
        if (field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(Version.class) || field.isAnnotationPresent(OId.class) || field.isAnnotationPresent(OVersion.class)) {
            modelProperty.isGenerated = true;
        }
        return modelProperty;
    }

    String getSearchQuery(List<String> searchFields, List<Object> params, String keywords) {
        String q = "";
        for (Model.Property property : this.listProperties()) {
            if (!property.isSearchable || searchFields != null && !searchFields.isEmpty() && !searchFields.contains(property.name)) continue;
            if (!q.equals("")) {
                q = q + " or ";
            }
            q = q + property.name + ".toLowerCase() like ?";
            params.add("%" + keywords + "%");
        }
        return q;
    }

    Field keyField() {
        Class<? extends Model> c = this.clazz;
        try {
            while (!c.equals(Object.class)) {
                for (Field field : c.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(OId.class)) continue;
                    field.setAccessible(true);
                    return field;
                }
                c = c.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new UnexpectedException("Error while determining the object @Id for an object of type " + this.clazz);
        }
        throw new UnexpectedException("Cannot get the object @Id for an object of type " + this.clazz);
    }

    protected List<Object> toList(OObjectIteratorMultiCluster<Object> result) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : result) {
            list.add(obj);
        }
        return list;
    }
}

