/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OChannelBinary
extends OChannel {
    public DataInputStream in;
    public DataOutputStream out;
    private final int maxChunkSize;
    private boolean debug;
    private final byte[] buffer;

    public OChannelBinary(Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super(iSocket, iConfig);
        this.maxChunkSize = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_BINARY_MAX_CONTENT_LENGTH);
        this.debug = iConfig.getValueAsBoolean(OGlobalConfiguration.NETWORK_BINARY_DEBUG);
        this.buffer = new byte[this.maxChunkSize];
    }

    public byte readByte() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Reading byte (1 byte)...", new Object[0]);
            byte value = this.in.readByte();
            OLogManager.instance().debug((Object)this, "Read byte: " + value, new Object[0]);
            return value;
        }
        return this.in.readByte();
    }

    public int readInt() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Reading int (4 bytes)...", new Object[0]);
            int value = this.in.readInt();
            OLogManager.instance().debug((Object)this, "Read int: " + value, new Object[0]);
            return value;
        }
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Reading long (8 bytes)...", new Object[0]);
            long value = this.in.readLong();
            OLogManager.instance().debug((Object)this, "Read long: " + value, new Object[0]);
            return value;
        }
        return this.in.readLong();
    }

    public short readShort() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Reading short (2 bytes)...", new Object[0]);
            short value = this.in.readShort();
            OLogManager.instance().debug((Object)this, "Read short: " + value, new Object[0]);
            return value;
        }
        return this.in.readShort();
    }

    public String readString() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Reading string (4+N bytes)...", new Object[0]);
            byte[] buffer = this.readBytes();
            if (buffer == null) {
                return null;
            }
            String value = new String(buffer);
            OLogManager.instance().debug((Object)this, "Read string: " + value, new Object[0]);
            return value;
        }
        byte[] buffer = this.readBytes();
        if (buffer == null) {
            return null;
        }
        return new String(buffer);
    }

    public byte[] readBytes() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Reading chunk of bytes. Reading chunk length as int (4 bytes)...", new Object[0]);
        }
        int len = this.in.readInt();
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Read chunk lenght: " + len, new Object[0]);
        }
        if (len < 0) {
            return null;
        }
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Reading " + len + " bytes...", new Object[0]);
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Read " + len + " bytes: " + new String(tmp), new Object[0]);
        }
        return tmp;
    }

    public List<String> readStringList() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Reading string list. Reading string list items as int (4 bytes)...", new Object[0]);
        }
        int items = this.in.readInt();
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Read string list items: " + items, new Object[0]);
        }
        if (items < 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < items; ++i) {
            result.add(this.readString());
        }
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Read string list with %d items: ", new Object[]{items});
        }
        return result;
    }

    public Set<String> readStringSet() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Reading string set. Reading string set items as int (4 bytes)...", new Object[0]);
        }
        int items = this.in.readInt();
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Read string set items: " + items, new Object[0]);
        }
        if (items < 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < items; ++i) {
            result.add(this.readString());
        }
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Read string set with %d items: ", new Object[]{items});
        }
        return result;
    }

    public ORecordId readRID() throws IOException {
        return new ORecordId((int)this.readShort(), this.readLong());
    }

    public void writeByte(byte iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Writing byte (1 byte): %d", new Object[]{iContent});
        }
        this.out.write(iContent);
    }

    public void writeInt(int iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Writing int (4 bytes): %d", new Object[]{iContent});
        }
        this.out.writeInt(iContent);
    }

    public void writeLong(long iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Writing long (8 bytes): %d", new Object[]{iContent});
        }
        this.out.writeLong(iContent);
    }

    public void writeShort(short iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Writing long (2 bytes): %d", new Object[]{iContent});
        }
        this.out.writeShort(iContent);
    }

    public OChannelBinary writeString(String iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Writing string (4+%d=%d bytes): %s", new Object[]{iContent != null ? iContent.length() : 0, iContent != null ? iContent.length() + 4 : 4, iContent});
        }
        if (iContent == null) {
            this.out.writeInt(-1);
        } else {
            this.writeBytes(iContent.getBytes());
        }
        return this;
    }

    public OChannelBinary writeBytes(byte[] iContent) throws IOException {
        return this.writeBytes(iContent, iContent != null ? iContent.length : 0);
    }

    public OChannelBinary writeBytes(byte[] iContent, int iLength) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Writing bytes (4+%d=%d bytes): %s", new Object[]{iLength, iLength + 4, iContent});
        }
        if (iContent == null) {
            this.out.writeInt(-1);
        } else {
            this.out.writeInt(iLength);
            this.out.write(iContent, 0, iLength);
        }
        return this;
    }

    public OChannelBinary writeCollectionString(Collection<String> iCollection) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "Writing strings (4+%d=%d items): %s", new Object[]{iCollection != null ? iCollection.size() : 0, iCollection != null ? iCollection.size() + 4 : 4, iCollection.toString()});
        }
        if (iCollection == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(iCollection.size());
            for (String s : iCollection) {
                this.writeString(s);
            }
        }
        return this;
    }

    public void writeRID(ORID iRID) throws IOException {
        this.writeShort((short)iRID.getClusterId());
        this.writeLong(iRID.getClusterPosition());
    }

    public void clearInput() throws IOException {
        if (this.in != null) {
            while (this.in.available() > 0) {
                this.in.read();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.acquireExclusiveLock();
        }
        catch (InterruptedException e1) {
            return;
        }
        try {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.close();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public int readStatus() throws IOException {
        return this.handleStatus(this.readByte(), this.readInt());
    }

    protected int handleStatus(byte iResult, int iClientTxId) throws IOException {
        if (iResult != 0 && iResult != 3) {
            if (iResult == 1) {
                StringBuilder buffer = new StringBuilder();
                ArrayList<OPair> exceptions = new ArrayList<OPair>();
                while (this.readByte() == 1) {
                    String excClassName = this.readString();
                    String excMessage = this.readString();
                    exceptions.add(new OPair((Comparable)((Object)excClassName), (Object)excMessage));
                }
                RuntimeException previous = null;
                for (int i = exceptions.size() - 1; i > -1; --i) {
                    previous = OChannelBinary.createException((String)((Object)((OPair)exceptions.get(i)).getKey()), (String)((OPair)exceptions.get(i)).getValue(), previous);
                }
                if (previous != null) {
                    if (previous instanceof RuntimeException) {
                        throw (RuntimeException)previous;
                    }
                    throw new ODatabaseException("Generic error, see the underlying cause", previous);
                }
                throw new ONetworkProtocolException("Network response error: " + buffer.toString());
            }
            throw new ONetworkProtocolException("Error on reading response from the server");
        }
        return iClientTxId;
    }

    private static RuntimeException createException(String iClassName, String iMessage, Exception iPrevious) {
        Object rootException = null;
        Constructor<?> c = null;
        try {
            Class<?> excClass = Class.forName(iClassName);
            if (iPrevious != null) {
                try {
                    c = excClass.getConstructor(String.class, Throwable.class);
                }
                catch (NoSuchMethodException e) {
                    c = excClass.getConstructor(String.class, Exception.class);
                }
            }
            if (c == null) {
                c = excClass.getConstructor(String.class);
            }
        }
        catch (Exception e) {
            rootException = new OStorageException(iMessage, (Throwable)iPrevious);
        }
        if (c != null) {
            try {
                rootException = c.getParameterTypes().length > 1 ? (RuntimeException)c.newInstance(iMessage, iPrevious) : (RuntimeException)c.newInstance(iMessage);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return rootException;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }
}

