/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.locks.ReentrantLock;

public class OChannelBinaryAsynch
extends OChannelBinary {
    private final ReentrantLock lockRead = new ReentrantLock();
    private final ReentrantLock lockWrite = new ReentrantLock();
    private boolean channelRead = false;
    private byte currentStatus;
    private int currentTxId;

    public OChannelBinaryAsynch(Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super(iSocket, iConfig);
    }

    public void beginRequest() {
        this.lockWrite.lock();
    }

    public void endRequest() throws IOException {
        this.out.flush();
        this.lockWrite.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int beginResponse(int iRequesterId) throws IOException {
        while (true) {
            this.lockRead.lock();
            if (!this.channelRead) {
                this.channelRead = true;
                try {
                    this.currentStatus = this.readByte();
                    this.currentTxId = this.readInt();
                }
                catch (IOException e) {
                    this.lockRead.unlock();
                    throw e;
                }
            }
            if (this.currentTxId == iRequesterId) break;
            this.lockRead.unlock();
            OChannelBinaryAsynch oChannelBinaryAsynch = this;
            synchronized (oChannelBinaryAsynch) {
                try {
                    ((Object)((Object)this)).wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.handleStatus(this.currentStatus, this.currentTxId);
        return iRequesterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endResponse() {
        this.channelRead = false;
        this.lockRead.unlock();
        OChannelBinaryAsynch oChannelBinaryAsynch = this;
        synchronized (oChannelBinaryAsynch) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public ReentrantLock getLockRead() {
        return this.lockRead;
    }

    public ReentrantLock getLockWrite() {
        return this.lockWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        OChannelBinaryAsynch oChannelBinaryAsynch = this;
        synchronized (oChannelBinaryAsynch) {
            ((Object)((Object)this)).notifyAll();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInput() throws IOException {
        this.lockRead.lock();
        try {
            super.clearInput();
        }
        finally {
            this.lockRead.unlock();
        }
    }
}

