/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import java.io.IOException;
import java.io.InputStream;

public class OChannelBinaryInputStream
extends InputStream {
    private OChannelBinary channel;
    private final byte[] buffer;
    private int pos = 0;
    private int total = -1;
    private boolean again = true;

    public OChannelBinaryInputStream(OChannelBinary channel) {
        this.channel = channel;
        this.buffer = channel.getBuffer();
    }

    public int read() throws IOException {
        if (this.pos >= this.total) {
            if (this.again) {
                this.fetch();
            } else {
                return -1;
            }
        }
        return this.buffer[this.pos++];
    }

    public int available() throws IOException {
        int remaining;
        if (this.total < 0) {
            this.fetch();
        }
        return (remaining = this.total - this.pos) > 0 ? remaining : (this.again ? 1 : 0);
    }

    private void fetch() throws IOException {
        this.pos = 0;
        this.total = this.channel.in.readInt();
        if (this.total > this.buffer.length) {
            throw new ONetworkProtocolException("Bad chunk size received: " + this.total + " when the maximum can be: " + this.buffer.length);
        }
        if (this.total > 0) {
            this.channel.in.readFully(this.buffer, 0, this.total);
        }
        this.again = this.channel.in.readByte() == 1;
    }
}

