/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.ORecordCache;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OAbstractRecordCache
extends OSharedResourceAbstract {
    protected boolean enabled = true;
    protected int maxSize;
    protected ORecordCache entries;
    protected OMemoryWatchDog.Listener watchDogListener;
    protected String profilerPrefix;

    public OAbstractRecordCache(String iProfilerPrefix, int iMaxSize) {
        this.profilerPrefix = iProfilerPrefix;
        this.maxSize = iMaxSize;
        int initialSize = this.maxSize > -1 ? this.maxSize + 1 : 1000;
        this.entries = new ORecordCache(this.maxSize, initialSize, 0.75f);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnable(boolean iValue) {
        this.enabled = iValue;
        if (!iValue) {
            this.entries.clear();
        }
    }

    public ORecordInternal<?> findRecord(ORID iRid) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORecordInternal<?> freeRecord(ORID iRID) {
        if (!this.enabled) {
            return null;
        }
        this.acquireExclusiveLock();
        try {
            ORecordInternal oRecordInternal = (ORecordInternal)this.entries.remove(iRID);
            return oRecordInternal;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeCluster(int clusterId) {
        if (!this.enabled) {
            return;
        }
        this.acquireExclusiveLock();
        HashSet<ORID> toRemove = new HashSet<ORID>();
        try {
            for (ORID entry : this.entries.keySet()) {
                if (entry.getClusterId() != clusterId) continue;
                toRemove.add(entry);
            }
            for (ORID ridToRemove : toRemove) {
                this.entries.remove(ridToRemove);
            }
        }
        finally {
            toRemove.clear();
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecords(Collection<ORID> iRecords) {
        if (!this.enabled) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            for (ORID id : iRecords) {
                this.entries.remove(id);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(ORID iRecord) {
        if (!this.enabled) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            this.entries.remove(iRecord);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsRecord(ORID iRID) {
        if (!this.enabled) {
            return false;
        }
        this.acquireSharedLock();
        try {
            boolean bl = this.entries.containsKey(iRID);
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!this.enabled) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            this.entries.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        this.acquireSharedLock();
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSize() {
        this.acquireSharedLock();
        try {
            int n = this.maxSize;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.acquireExclusiveLock();
        try {
            this.entries.clear();
            Orient.instance().getMemoryWatchDog().removeListener(this.watchDogListener);
            this.watchDogListener = null;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void setMaxSize(int iMaxSize) {
        this.maxSize = iMaxSize;
    }

    public void startup() {
        this.watchDogListener = Orient.instance().getMemoryWatchDog().addListener(new OMemoryWatchDog.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void memoryUsageLow(OMemoryWatchDog.Listener.TYPE iType, long usedMemory, long maxMemory) {
                if (iType == OMemoryWatchDog.Listener.TYPE.JVM) {
                    OAbstractRecordCache.this.acquireExclusiveLock();
                    try {
                        int oldSize = OAbstractRecordCache.this.entries.size();
                        if (oldSize == 0) {
                            return;
                        }
                        int threshold = (int)((float)oldSize * 0.9f);
                        OAbstractRecordCache.this.entries.removeEldestItems(threshold);
                        OLogManager.instance().debug((Object)this, "Low memory: auto reduce the record cache size from %d to %d", new Object[]{oldSize, threshold});
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error while freeing resources", (Throwable)e, new Object[0]);
                    }
                    finally {
                        OAbstractRecordCache.this.releaseExclusiveLock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void memoryUsageCritical(OMemoryWatchDog.Listener.TYPE iType, long usedMemory, long maxMemory) {
                if (iType == OMemoryWatchDog.Listener.TYPE.JVM) {
                    OAbstractRecordCache.this.acquireExclusiveLock();
                    try {
                        OLogManager.instance().debug((Object)this, "Clearing %d resources", new Object[]{OAbstractRecordCache.this.entries.size()});
                        OAbstractRecordCache.this.entries.clear();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error while freeing resources", (Throwable)e, new Object[0]);
                    }
                    finally {
                        OAbstractRecordCache.this.releaseExclusiveLock();
                    }
                }
            }
        });
        OProfiler.getInstance().registerHookValue(this.profilerPrefix + ".cache.enabled", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OAbstractRecordCache.this.enabled;
            }
        });
        OProfiler.getInstance().registerHookValue(this.profilerPrefix + ".cache.current", new OProfiler.OProfilerHookValue(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getValue() {
                OAbstractRecordCache.this.acquireSharedLock();
                try {
                    Integer n = OAbstractRecordCache.this.entries.size();
                    return n;
                }
                finally {
                    OAbstractRecordCache.this.releaseSharedLock();
                }
            }
        });
        OProfiler.getInstance().registerHookValue(this.profilerPrefix + ".cache.max", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OAbstractRecordCache.this.maxSize;
            }
        });
    }
}

