/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.cache.OAbstractRecordCache;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLevel1RecordCache
extends OAbstractRecordCache {
    private final ODatabaseRecord database;
    private OLevel2RecordCache level2cache;
    private String PROFILER_CACHE_FOUND;
    private String PROFILER_CACHE_NOTFOUND;

    public OLevel1RecordCache(ODatabaseRecord iDatabase) {
        super("db." + iDatabase.getName(), OGlobalConfiguration.CACHE_LEVEL1_SIZE.getValueAsInteger());
        this.database = iDatabase;
    }

    @Override
    public void startup() {
        this.profilerPrefix = "db." + this.database.getName();
        this.PROFILER_CACHE_FOUND = this.profilerPrefix + ".cache.found";
        this.PROFILER_CACHE_NOTFOUND = this.profilerPrefix + ".cache.notFound";
        super.startup();
        this.level2cache = this.database.getLevel2Cache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(ORecordInternal<?> iRecord) {
        if (this.enabled) {
            this.acquireExclusiveLock();
            try {
                if (this.entries.get(iRecord.getIdentity()) != iRecord) {
                    this.entries.put(iRecord.getIdentity(), iRecord);
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            {
            }
        }
        this.level2cache.updateRecord(iRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordInternal<?> findRecord(ORID iRID) {
        ORecordInternal<?> record;
        if (!this.enabled) {
            return null;
        }
        this.acquireSharedLock();
        try {
            record = (ORecordInternal<?>)this.entries.get(iRID);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        if (record == null && (record = this.level2cache.retrieveRecord(iRID)) != null) {
            record.setDatabase(this.database);
            this.acquireExclusiveLock();
            try {
                this.entries.put(record.getIdentity(), record);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            {
            }
        }
        OProfiler.getInstance().updateCounter(record != null ? this.PROFILER_CACHE_FOUND : this.PROFILER_CACHE_NOTFOUND, 1L);
        return record;
    }

    @Override
    public void deleteRecord(ORID iRecord) {
        super.deleteRecord(iRecord);
        this.level2cache.freeRecord(iRecord);
    }

    @Override
    public void shutdown() {
        this.clear();
        super.shutdown();
        this.level2cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.acquireExclusiveLock();
        try {
            if (this.level2cache != null) {
                this.level2cache.moveRecords(this.entries.values());
            }
            this.entries.clear();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        this.acquireExclusiveLock();
        try {
            this.entries.clear();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    public String toString() {
        return "DB level1 cache records=" + this.getSize() + ", maxSize=" + this.maxSize;
    }
}

