/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.orient.core.cache.OAbstractRecordCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLevel2RecordCache
extends OAbstractRecordCache {
    private final OStorage storage;
    private STRATEGY strategy;

    public OLevel2RecordCache(OStorage iStorage) {
        super("storage." + iStorage.getName(), OGlobalConfiguration.CACHE_LEVEL2_SIZE.getValueAsInteger());
        this.storage = iStorage;
        this.setStrategy(OGlobalConfiguration.CACHE_LEVEL2_STRATEGY.getValueAsInteger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveRecords(Collection<ORecordInternal<?>> iValues) {
        if (!this.enabled) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            for (ORecordInternal<?> record : iValues) {
                if (record == null || record.isDirty() || record.getIdentity().isNew()) continue;
                if (record.isPinned()) {
                    ORecordInternal prevEntry = (ORecordInternal)this.entries.get(record.getIdentity());
                    if (prevEntry != null && prevEntry.getVersion() >= record.getVersion()) continue;
                    record.detach();
                    this.entries.put(record.getIdentity(), record);
                    continue;
                }
                this.entries.remove(record.getIdentity());
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(ORecordInternal<?> iRecord) {
        if (!this.enabled || iRecord == null || iRecord.isDirty() || iRecord.getIdentity().isNew()) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            if (iRecord.isPinned()) {
                ORecordInternal prevEntry = (ORecordInternal)this.entries.get(iRecord.getIdentity());
                if (prevEntry != null && prevEntry.getVersion() >= iRecord.getVersion()) {
                    return;
                }
                if (iRecord.getDatabase() == null || iRecord.getDatabase().isClosed()) {
                    iRecord.detach();
                    this.entries.put(iRecord.getIdentity(), iRecord);
                } else {
                    this.entries.put(iRecord.getIdentity(), (ORecordInternal)iRecord.flatCopy());
                }
            } else {
                this.entries.remove(iRecord.getIdentity());
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ORecordInternal<?> retrieveRecord(ORID iRID) {
        if (!this.enabled) {
            return null;
        }
        this.acquireExclusiveLock();
        try {
            ORecordInternal record = (ORecordInternal)this.entries.remove(iRID);
            if (record == null || record.isDirty()) {
                ORecordInternal<?> oRecordInternal = null;
                return oRecordInternal;
            }
            if (this.strategy == STRATEGY.COPY_RECORD) {
                this.entries.put(iRID, (ORecordInternal)record.flatCopy());
            }
            ORecordInternal oRecordInternal = record;
            return oRecordInternal;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public STRATEGY getStrategy() {
        return this.strategy;
    }

    public void setStrategy(STRATEGY iStrategy) {
        this.strategy = iStrategy;
    }

    public void setStrategy(int iStrategy) {
        this.strategy = STRATEGY.values()[iStrategy];
    }

    public String toString() {
        return "STORAGE level2 cache records=" + this.getSize() + ", maxSize=" + this.maxSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STRATEGY {
        POP_RECORD,
        COPY_RECORD;

    }
}

