/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.orient.core.command.OCommandRequestAbstract;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.core.serialization.OMemoryOutputStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OCommandRequestTextAbstract
extends OCommandRequestAbstract
implements OCommandRequestText {
    protected String text;

    protected OCommandRequestTextAbstract() {
    }

    protected OCommandRequestTextAbstract(String iText) {
        this(iText, null);
    }

    protected OCommandRequestTextAbstract(String iText, ODatabaseRecord iDatabase) {
        super(iDatabase);
        if (iText == null) {
            throw new IllegalArgumentException("Text can't be null");
        }
        this.text = iText.trim();
    }

    @Override
    public <RET> RET execute(Object ... iArgs) {
        this.setParameters(iArgs);
        return (RET)this.database.getStorage().command(this);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public OCommandRequestText setText(String iText) {
        this.text = iText;
        return this;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OMemoryInputStream buffer = new OMemoryInputStream(iStream);
        try {
            this.text = buffer.getAsString();
            byte[] paramBuffer = buffer.getAsByteArray();
            if (paramBuffer.length == 0) {
                this.parameters = null;
            } else {
                ODocument param = new ODocument(this.database);
                param.fromStream(paramBuffer);
                Map params = (Map)param.field("params");
                this.parameters = new HashMap();
                for (Map.Entry p : params.entrySet()) {
                    Object value = p.getValue() instanceof String ? ORecordSerializerStringAbstract.getTypeValue((String)p.getValue()) : p.getValue();
                    if (Character.isDigit(((String)p.getKey()).charAt(0))) {
                        this.parameters.put(Integer.parseInt((String)p.getKey()), value);
                        continue;
                    }
                    this.parameters.put(p.getKey(), value);
                }
            }
        }
        catch (IOException e) {
            throw new OSerializationException("Error while unmarshalling OCommandRequestTextAbstract impl", e);
        }
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        OMemoryOutputStream buffer = new OMemoryOutputStream();
        try {
            buffer.add(this.text);
            if (this.parameters == null || this.parameters.size() == 0) {
                buffer.add(new byte[0]);
            } else {
                ODocument param = new ODocument(this.database);
                param.field("params", this.parameters);
                buffer.add(param.toStream());
            }
        }
        catch (IOException e) {
            throw new OSerializationException("Error while marshalling OCommandRequestTextAbstract impl", e);
        }
        return buffer.toByteArray();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [text=" + this.text + "]";
    }
}

