/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OConfigurationChangeCallback;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OGlobalConfiguration {
    ENVIRONMENT_CONCURRENT("environment.concurrent", "Tells if runs in multi-threads environment. Setting this to false turns off the internal lock management", Boolean.class, Boolean.TRUE),
    MEMORY_OPTIMIZE_THRESHOLD("memory.optimizeThreshold", "Threshold of heap memory where to start the optimization of memory usage. ", Float.class, 0.7, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OMemoryWatchDog.setPercentageUsageThreshold(((Number)iNewValue).floatValue());
        }
    }),
    STORAGE_KEEP_OPEN("storage.keepOpen", "Tells to the engine to not close the storage when a database is closed. Storages will be closed when the process will shutdown", Boolean.class, Boolean.TRUE),
    STORAGE_LOCK_TIMEOUT("storage.record.lockTimeout", "Maximum timeout in milliseconds to lock a shared record", Integer.class, 5000),
    CACHE_LEVEL1_ENABLED("cache.level1.enabled", "Uses the level-1 cache", Boolean.class, true),
    CACHE_LEVEL1_SIZE("cache.level1.size", "Size of the cache that keep the record in memory", Integer.class, -1),
    CACHE_LEVEL2_ENABLED("cache.level2.enabled", "Uses the level-2 cache", Boolean.class, true),
    CACHE_LEVEL2_SIZE("cache.level2.size", "Size of the cache that keep the record in memory", Integer.class, -1),
    CACHE_LEVEL2_STRATEGY("cache.level2.strategy", "Strategy to use when a database asks for a record: 0 = pop the record, 1 = copy the record", Integer.class, 0, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
        }
    }),
    OBJECT_SAVE_ONLY_DIRTY("object.saveOnlyDirty", "Object Database saves only object bound to dirty records", Boolean.class, false),
    DB_MVCC("db.mvcc", "Enable the MVCC (Multi-Version Concurrency Control) even outside transactions", Boolean.class, true),
    TX_USE_LOG("tx.useLog", "Transactions use log file to store temporary data to being rollbacked in case of crash", Boolean.class, false),
    TX_COMMIT_SYNCH("tx.commit.synch", "Synchronizes the storage after transaction commit", Boolean.class, false),
    BLUEPRINTS_TX_MODE("blueprints.graph.txMode", "Transaction mode used in TinkerPop Blueprints implementation. 0 = Automatic (default), 1 = Manual", Integer.class, 0),
    MVRBTREE_LAZY_UPDATES("mvrbtree.lazyUpdates", "Configure the TreeMaps (indexes and dictionaries) as buffered or not. -1 means buffered up to tx.commit() or db.close()", Integer.class, 20000),
    MVRBTREE_NODE_PAGE_SIZE("mvrbtree.nodePageSize", "Page size of each single node. 512 means that 512 entries can be stored inside a node", Integer.class, 512),
    MVRBTREE_LOAD_FACTOR("mvrbtree.loadFactor", "HashMap load factor", Float.class, Float.valueOf(0.7f)),
    MVRBTREE_OPTIMIZE_THRESHOLD("mvrbtree.optimizeThreshold", "Auto optimize the TreeMap every X tree rotations. This force the optimization of the tree after many changes to recompute entrypoints. -1 means never", Integer.class, 100000),
    MVRBTREE_ENTRYPOINTS("mvrbtree.entryPoints", "Number of entry points to start searching entries", Integer.class, 64),
    MVRBTREE_OPTIMIZE_ENTRYPOINTS_FACTOR("mvrbtree.optimizeEntryPointsFactor", "Multiplicand factor to apply to entry-points list (parameter mvrbtree.entrypoints) to determine if needs of optimization", Float.class, Float.valueOf(1.0f)),
    LAZYSET_WORK_ON_STREAM("lazyset.workOnStream", "Upon add avoid to unmarshall set", Boolean.class, true),
    FILE_LOCK("file.lock", "Locks files when used. Default is false for local connections and true when runs as Server", Boolean.TYPE, true),
    FILE_DEFRAG_STRATEGY("file.defrag.strategy", "Strategy to recycle free space. 0 = Recycles the first hole with enough size: fast, 1 = recycles the best hole: better usage of space but slower", Integer.class, 0),
    FILE_DEFRAG_HOLE_MAX_DISTANCE("file.defrag.holeMaxDistance", "Max distance in bytes between holes to execute the defrag of them. Set it to -1 to use dynamic size. Pay attention that is db is huge, then moving blocks to defrag could be expensive", Integer.class, 32768),
    FILE_MMAP_STRATEGY("file.mmap.strategy", "Strategy to use with memory mapped files. 0 = USE MMAP ALWAYS, 1 = USE MMAP ON WRITES OR ON READ JUST WHEN THE BLOCK POOL IS FREE, 2 = USE MMAP ON WRITES OR ON READ JUST WHEN THE BLOCK IS ALREADY AVAILABLE, 3 = USE MMAP ONLY IF BLOCK IS ALREADY AVAILABLE, 4 = NEVER USE MMAP", Integer.class, 0),
    FILE_MMAP_BLOCK_SIZE("file.mmap.blockSize", "Size of the memory mapped block, default is 1Mb", Integer.class, 0x100000, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OMMapManager.setBlockSize(((Number)iNewValue).intValue());
        }
    }),
    FILE_MMAP_BUFFER_SIZE("file.mmap.bufferSize", "Size of the buffer for direct access to the file through the channel", Integer.class, 8192),
    FILE_MMAP_MAX_MEMORY("file.mmap.maxMemory", "Max memory allocable by memory mapping manager. Note that on 32bit OS the limit is to 2Gb but can change to OS by OS", Long.class, 0x8000000, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OMMapManager.setMaxMemory(OFileUtils.getSizeAsNumber((Object)iNewValue));
        }
    }),
    FILE_MMAP_OVERLAP_STRATEGY("file.mmap.overlapStrategy", "Strategy when a request overlap in-memory buffers: 0 = Use the channel access, 1 = force the in memory buffer and use the channel access, 2 = always create an overlapped in-memory buffer (default)", Integer.class, 2, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OMMapManager.setOverlapStrategy((Integer)iNewValue);
        }
    }),
    FILE_MMAP_FORCE_DELAY("file.mmap.forceDelay", "Delay time in ms to wait for another force flush of the memory mapped block to the disk", Integer.class, 10),
    FILE_MMAP_FORCE_RETRY("file.mmap.forceRetry", "Number of times the memory mapped block will try to flush to the disk", Integer.class, 50),
    NETWORK_SOCKET_BUFFER_SIZE("network.socketBufferSize", "TCP/IP Socket buffer size", Integer.class, 32768),
    NETWORK_LOCK_TIMEOUT("network.lockTimeout", "Timeout in ms to acquire a lock against a channel", Integer.class, 15000),
    NETWORK_SOCKET_TIMEOUT("network.socketTimeout", "TCP/IP Socket timeout in ms", Integer.class, 10000),
    NETWORK_SOCKET_RETRY("network.retry", "Number of times the client connection retries to connect to the server in case of failure", Integer.class, 5),
    NETWORK_SOCKET_RETRY_DELAY("network.retryDelay", "Number of ms the client wait to reconnect to the server in case of failure", Integer.class, 500),
    NETWORK_BINARY_MAX_CONTENT_LENGTH("network.binary.maxLength", "TCP/IP max content length in bytes of BINARY requests", Integer.class, 100000),
    NETWORK_BINARY_DEBUG("network.binary.debug", "Debug mode: print all the incoming data on binary channel", Boolean.class, false),
    NETWORK_HTTP_MAX_CONTENT_LENGTH("network.http.maxLength", "TCP/IP max content length in bytes of HTTP requests", Integer.class, 100000),
    NETWORK_HTTP_SESSION_EXPIRE_TIMEOUT("network.http.sessionExpireTimeout", "Timeout to consider a http session expired in ms", Integer.class, 600000),
    PROFILER_ENABLED("profiler.enabled", "Enable the recording of statistics and counters", Boolean.class, false, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            if (((Boolean)iNewValue).booleanValue()) {
                OProfiler.getInstance().startRecording();
            } else {
                OProfiler.getInstance().stopRecording();
            }
        }
    }),
    LOG_CONSOLE_LEVEL("log.console.level", "Console's logging level", String.class, "info", new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OLogManager.instance().setLevel((String)iNewValue, ConsoleHandler.class);
        }
    }),
    LOG_FILE_LEVEL("log.file.level", "File's logging level", String.class, "fine", new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OLogManager.instance().setLevel((String)iNewValue, FileHandler.class);
        }
    }),
    CLIENT_CHANNEL_MIN_POOL("client.channel.minPool", "Minimum size of the channel pool", Integer.class, 1),
    CLIENT_CHANNEL_MAX_POOL("client.channel.maxPool", "Maximum size of the channel pool", Integer.class, 1),
    SERVER_CACHE_FILE_STATIC("server.cache.file.static", "Cache static resources after loaded", Boolean.class, false),
    DISTRIBUTED_ASYNC_TIME_DELAY("distributed.async.timeDelay", "Delay time (in ms) of synchronization with slave nodes. 0 means early synchronization", Integer.class, 0),
    DISTRIBUTED_SYNC_MAXRECORDS_BUFFER("distributed.sync.maxRecordsBuffer", "Maximum number of records to buffer before to send to the slave nodes", Integer.class, 100);

    private final String key;
    private final Object defValue;
    private final Class<?> type;
    private Object value = null;
    private String description;
    private OConfigurationChangeCallback changeCallback = null;

    private OGlobalConfiguration(String iKey, String iDescription, Class<?> iType, Object iDefValue, OConfigurationChangeCallback iChangeAction) {
        this(iKey, iDescription, iType, iDefValue);
        this.changeCallback = iChangeAction;
    }

    private OGlobalConfiguration(String iKey, String iDescription, Class<?> iType, Object iDefValue) {
        this.key = iKey;
        this.description = iDescription;
        this.defValue = iDefValue;
        this.type = iType;
    }

    public void setValue(Object iValue) {
        Object oldValue = this.value;
        if (iValue != null) {
            this.value = this.type == Boolean.class ? Boolean.valueOf(Boolean.parseBoolean(iValue.toString())) : (this.type == Integer.class ? Integer.valueOf(Integer.parseInt(iValue.toString())) : (this.type == Float.class ? Float.valueOf(Float.parseFloat(iValue.toString())) : (this.type == String.class ? iValue.toString() : iValue)));
        }
        if (this.changeCallback != null) {
            this.changeCallback.change(oldValue, this.value);
        }
    }

    public Object getValue() {
        return this.value != null ? this.value : this.defValue;
    }

    public boolean getValueAsBoolean() {
        Object v = this.value != null ? this.value : this.defValue;
        return v instanceof Boolean ? (Boolean)v : Boolean.parseBoolean(v.toString());
    }

    public String getValueAsString() {
        Object v = this.value != null ? this.value : this.defValue;
        return v.toString();
    }

    public int getValueAsInteger() {
        Object v = this.value != null ? this.value : this.defValue;
        return v instanceof Number ? ((Number)v).intValue() : Integer.parseInt(v.toString());
    }

    public long getValueAsLong() {
        Object v = this.value != null ? this.value : this.defValue;
        return v instanceof Number ? ((Number)v).longValue() : Long.parseLong(v.toString());
    }

    public float getValueAsFloat() {
        Object v = this.value != null ? this.value : this.defValue;
        return v instanceof Float ? ((Float)v).floatValue() : Float.parseFloat(v.toString());
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public static OGlobalConfiguration findByKey(String iKey) {
        for (OGlobalConfiguration v : OGlobalConfiguration.values()) {
            if (!v.getKey().equalsIgnoreCase(iKey)) continue;
            return v;
        }
        return null;
    }

    public static void setConfiguration(Map<String, Object> iConfig) {
        for (Map.Entry<String, Object> config : iConfig.entrySet()) {
            OGlobalConfiguration cfg = OGlobalConfiguration.valueOf(config.getKey());
            if (cfg == null) continue;
            cfg.setValue(config.getValue());
        }
    }

    private static void readConfiguration() {
        for (OGlobalConfiguration config : OGlobalConfiguration.values()) {
            String prop = System.getProperty(config.key);
            if (prop == null) continue;
            config.setValue(prop);
        }
    }

    private static void autoConfig() {
        if (System.getProperty("os.name").indexOf("Windows") > -1) {
            // empty if block
        }
        if (System.getProperty("os.arch").indexOf("64") > -1 && FILE_MMAP_MAX_MEMORY.getValueAsInteger() == 0x8000000) {
            OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
            try {
                Class<?> cls = Class.forName("com.sun.management.OperatingSystemMXBean");
                if (cls.isAssignableFrom(bean.getClass())) {
                    Long maxOsMemory = (Long)cls.getMethod("getTotalPhysicalMemorySize", new Class[0]).invoke((Object)bean, new Object[0]);
                    long maxProcessMemory = Runtime.getRuntime().maxMemory();
                    long mmapBestMemory = (maxOsMemory - maxProcessMemory) / 2L;
                    FILE_MMAP_MAX_MEMORY.setValue(mmapBestMemory);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        OGlobalConfiguration.readConfiguration();
        OGlobalConfiguration.autoConfig();
    }
}

