/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordWrapperAbstract;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseDocumentTx
extends ODatabaseRecordWrapperAbstract<ODatabaseRecordTx>
implements ODatabaseDocument {
    public ODatabaseDocumentTx(String iURL) {
        super(new ODatabaseRecordTx(iURL, 100));
    }

    @Override
    public ODocument newInstance() {
        return new ODocument(this);
    }

    @Override
    public ODocument newInstance(String iClassName) {
        this.checkSecurity("database.class", 1, (Object)iClassName);
        return new ODocument((ODatabaseRecord)this, iClassName);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName, boolean iPolymorphic) {
        if (this.getMetadata().getSchema().getClass(iClassName) == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in current database");
        }
        this.checkSecurity("database.class", 2, (Object)iClassName);
        return new ORecordIteratorClass<ODocument>(this, (ODatabaseRecordAbstract)this.underlying, iClassName, iPolymorphic);
    }

    @Override
    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName) {
        this.checkSecurity("database.cluster", 2, (Object)iClusterName);
        return new ORecordIteratorCluster<ODocument>(this, (ODatabaseRecordAbstract)this.underlying, this.getClusterIdByName(iClusterName));
    }

    public ODatabaseDocumentTx save(ORecordInternal<?> iRecord) {
        if (!(iRecord instanceof ODocument)) {
            return (ODatabaseDocumentTx)super.save(iRecord);
        }
        ODocument doc = (ODocument)iRecord;
        doc.validate();
        try {
            if (doc.getIdentity().isNew()) {
                if (doc.getClassName() != null) {
                    this.checkSecurity("database.class", 1, (Object)doc.getClassName());
                }
                if (doc.getSchemaClass() != null) {
                    String clusterName = this.getClusterNameById(doc.getSchemaClass().getDefaultClusterId());
                    super.save(doc, clusterName);
                    return this;
                }
            } else if (doc.getClassName() != null) {
                this.checkSecurity("database.class", 4, (Object)doc.getClassName());
            }
            super.save(doc);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on saving record %s of class '%s'", e, ODatabaseException.class, new Object[]{iRecord.getIdentity(), doc.getClassName() != null ? doc.getClassName() : "?"});
        }
        return this;
    }

    public ODatabaseDocumentTx save(ORecordInternal<?> iContent, String iClusterName) {
        if (!(iContent instanceof ODocument)) {
            return (ODatabaseDocumentTx)super.save(iContent, iClusterName);
        }
        ODocument doc = (ODocument)iContent;
        if (!doc.getIdentity().isValid()) {
            int[] clusterIds;
            int id;
            if (doc.getClassName() != null) {
                this.checkSecurity("database.class", 1, (Object)doc.getClassName());
            }
            if (iClusterName == null && doc.getSchemaClass() != null) {
                iClusterName = this.getClusterNameById(doc.getSchemaClass().getDefaultClusterId());
            }
            if ((id = this.getClusterIdByName(iClusterName)) == -1) {
                throw new IllegalArgumentException("Cluster name " + iClusterName + " is not configured");
            }
            if (doc.getSchemaClass() != null) {
                clusterIds = doc.getSchemaClass().getClusterIds();
                for (int i = 0; i < clusterIds.length && clusterIds[i] != id; ++i) {
                }
            } else {
                clusterIds = new int[]{id};
            }
            if (id == clusterIds.length) {
                throw new IllegalArgumentException("Cluster name " + iClusterName + " is not configured to store the class " + doc.getClassName());
            }
        } else if (doc.getClassName() != null) {
            this.checkSecurity("database.class", 4, (Object)doc.getClassName());
        }
        doc.validate();
        super.save(doc, iClusterName);
        return this;
    }

    public ODatabaseDocumentTx delete(ODocument iContent) {
        if (iContent.getClassName() != null) {
            this.checkSecurity("database.class", 8, (Object)iContent.getClassName());
        }
        try {
            ((ODatabaseRecordTx)this.underlying).delete(iContent);
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on deleting record %s of class '%s'", e, ODatabaseException.class, new Object[]{iContent.getIdentity(), iContent.getClassName()});
        }
        return this;
    }

    @Override
    public long countClass(String iClassName) {
        OClass cls = this.getMetadata().getSchema().getClass(iClassName);
        if (cls == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in database");
        }
        return cls.count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseComplex<ORecordInternal<?>> commit() {
        try {
            ODatabaseRecord oDatabaseRecord = ((ODatabaseRecordTx)this.underlying).commit();
            Object var3_2 = null;
            this.getTransaction().close();
            return oDatabaseRecord;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.getTransaction().close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseComplex<ORecordInternal<?>> rollback() {
        try {
            ODatabaseRecord oDatabaseRecord = ((ODatabaseRecordTx)this.underlying).rollback();
            Object var3_2 = null;
            this.getTransaction().close();
            return oDatabaseRecord;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.getTransaction().close();
            throw throwable;
        }
    }
}

