/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.graph;

import com.orientechnologies.orient.core.annotation.OAfterDeserialization;
import com.orientechnologies.orient.core.db.graph.ODatabaseGraphTx;
import com.orientechnologies.orient.core.db.graph.OGraphEdge;
import com.orientechnologies.orient.core.db.graph.OGraphElement;
import com.orientechnologies.orient.core.exception.OGraphException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OGraphVertex
extends OGraphElement
implements Cloneable {
    private SoftReference<Set<OGraphEdge>> in;
    private SoftReference<Set<OGraphEdge>> out;

    public OGraphVertex(ODatabaseGraphTx iDatabase) {
        super(iDatabase, "OGraphVertex");
    }

    public OGraphVertex(ODatabaseGraphTx iDatabase, String iClassName) {
        super(iDatabase, iClassName != null ? iClassName : "OGraphVertex");
    }

    public OGraphVertex(ODatabaseGraphTx iDatabase, ODocument iDocument) {
        super(iDatabase, iDocument);
    }

    public OGraphVertex(ODatabaseGraphTx iDatabase, ODocument iDocument, String iFetchPlan) {
        super(iDatabase, iDocument);
    }

    @Override
    public <RET extends ODocumentWrapper> RET save() {
        super.save();
        if (this.database != null) {
            this.database.registerUserObject(this, this.document);
        }
        return (RET)this;
    }

    public OGraphVertex clone() {
        return new OGraphVertex(this.database, this.document);
    }

    @Override
    @OAfterDeserialization
    public void fromStream(ODocument iDocument) {
        super.fromStream(iDocument);
        this.document.setTrackingChanges(false);
        this.out = null;
        this.in = null;
    }

    public OGraphEdge link(OGraphVertex iTargetVertex, String iClassName) {
        if (iTargetVertex == null) {
            throw new IllegalArgumentException("Missed the target vertex");
        }
        OGraphEdge edge = new OGraphEdge(this.database, iClassName, this, iTargetVertex);
        this.getOutEdges().add(edge);
        Set<ODocument> recordEdges = (HashSet<ODocument>)this.document.field("out");
        if (recordEdges == null) {
            recordEdges = new HashSet<ODocument>();
            this.document.field("out", recordEdges);
        }
        recordEdges.add(edge.getDocument());
        this.document.setDirty();
        iTargetVertex.getInEdges().add(edge);
        recordEdges = (Set)iTargetVertex.getDocument().field("in");
        if (recordEdges == null) {
            recordEdges = new HashSet();
            iTargetVertex.getDocument().field("in", recordEdges);
        }
        recordEdges.add(edge.getDocument());
        iTargetVertex.getDocument().setDirty();
        return edge;
    }

    public OGraphEdge link(OGraphVertex iTargetVertex) {
        return this.link(iTargetVertex, null);
    }

    public OGraphVertex unlink(OGraphVertex iTargetVertex) {
        if (iTargetVertex == null) {
            throw new IllegalArgumentException("Missed the target vertex");
        }
        OGraphVertex.unlink(this.database, this.document, iTargetVertex.getDocument());
        return this;
    }

    public boolean hasInEdges() {
        Set docs = (Set)this.document.field("in");
        return docs != null && !docs.isEmpty();
    }

    public boolean hasOutEdges() {
        Set docs = (Set)this.document.field("out");
        return docs != null && !docs.isEmpty();
    }

    public Set<OGraphEdge> getInEdges() {
        return this.getInEdges(null);
    }

    public Set<OGraphEdge> getInEdges(String iEdgeLabel) {
        Set<OGraphEdge> temp;
        Set<OGraphEdge> set = temp = this.in != null ? this.in.get() : null;
        if (temp == null) {
            if (iEdgeLabel == null) {
                temp = new HashSet<OGraphEdge>();
            }
            this.in = new SoftReference<Set<OGraphEdge>>(temp);
            Set docs = (Set)this.document.field("in");
            if (docs != null) {
                for (Object o : docs) {
                    ODocument doc = o instanceof ODocument ? (ODocument)o : this.database.getRecordById((ORID)o);
                    if (iEdgeLabel != null && !iEdgeLabel.equals(doc.field("label"))) continue;
                    temp.add((OGraphEdge)this.database.getUserObjectByRecord(doc, null));
                }
            }
        } else if (iEdgeLabel != null) {
            HashSet<OGraphEdge> filtered = new HashSet<OGraphEdge>();
            for (OGraphEdge e : temp) {
                if (!iEdgeLabel.equals(e.getLabel())) continue;
                filtered.add(e);
            }
            temp = filtered;
        }
        return temp;
    }

    public Set<OGraphEdge> getOutEdges() {
        return this.getOutEdges(null);
    }

    public Set<OGraphEdge> getOutEdges(String iEdgeLabel) {
        Set<OGraphEdge> temp;
        Set<OGraphEdge> set = temp = this.out != null ? this.out.get() : null;
        if (temp == null) {
            Set docs;
            temp = new HashSet<OGraphEdge>();
            if (iEdgeLabel == null) {
                this.out = new SoftReference<Set<OGraphEdge>>(temp);
            }
            if ((docs = (Set)this.document.field("out")) != null) {
                for (Object o : docs) {
                    ODocument doc = o instanceof ODocument ? (ODocument)o : this.database.getRecordById((ORID)o);
                    if (iEdgeLabel != null && !iEdgeLabel.equals(doc.field("label"))) continue;
                    temp.add((OGraphEdge)this.database.getUserObjectByRecord(doc, null));
                }
            }
        } else if (iEdgeLabel != null) {
            HashSet<OGraphEdge> filtered = new HashSet<OGraphEdge>();
            for (OGraphEdge e : temp) {
                if (!iEdgeLabel.equals(e.getLabel())) continue;
                filtered.add(e);
            }
            temp = filtered;
        }
        return temp;
    }

    public Set<OGraphVertex> browseOutEdgesVertexes() {
        HashSet<OGraphVertex> resultset;
        block3: {
            Set<OGraphEdge> temp;
            block2: {
                resultset = new HashSet<OGraphVertex>();
                Set<OGraphEdge> set = temp = this.out != null ? this.out.get() : null;
                if (temp != null) break block2;
                Set docEdges = (Set)this.document.field("out");
                if (docEdges == null) break block3;
                for (ODocument d : docEdges) {
                    resultset.add((OGraphVertex)this.database.getUserObjectByRecord((ODocument)d.field("in"), null));
                }
                break block3;
            }
            for (OGraphEdge edge : temp) {
                resultset.add(edge.getIn());
            }
        }
        return resultset;
    }

    public Set<OGraphVertex> browseInEdgesVertexes() {
        HashSet<OGraphVertex> resultset;
        block3: {
            Set<OGraphEdge> temp;
            block2: {
                resultset = new HashSet<OGraphVertex>();
                Set<OGraphEdge> set = temp = this.in != null ? this.in.get() : null;
                if (temp != null) break block2;
                Set docEdges = (Set)this.document.field("in");
                if (docEdges == null) break block3;
                for (ODocument d : docEdges) {
                    resultset.add((OGraphVertex)this.database.getUserObjectByRecord((ODocument)d.field("out"), null));
                }
                break block3;
            }
            for (OGraphEdge edge : temp) {
                resultset.add(edge.getOut());
            }
        }
        return resultset;
    }

    public ODocument findInVertex(OGraphVertex iVertexDocument) {
        Set docs = (Set)this.document.field("in");
        if (docs == null || docs.size() == 0) {
            return null;
        }
        for (ODocument d : docs) {
            if (!((ODocument)d.field("in")).equals(iVertexDocument.getDocument())) continue;
            return d;
        }
        return null;
    }

    public ODocument findOutVertex(OGraphVertex iVertexDocument) {
        Set docs = (Set)this.document.field("out");
        if (docs == null || docs.size() == 0) {
            return null;
        }
        for (ODocument d : docs) {
            if (!((ODocument)d.field("out")).equals(iVertexDocument.getDocument())) continue;
            return d;
        }
        return null;
    }

    public int getInEdgeCount() {
        Set docs = (Set)this.document.field("in");
        return docs == null ? 0 : docs.size();
    }

    public int getOutEdgeCount() {
        Set docs = (Set)this.document.field("out");
        return docs == null ? 0 : docs.size();
    }

    @Override
    public void reset() {
        this.document = null;
        this.in = null;
        this.out = null;
    }

    @Override
    public void delete() {
        if (this.in != null && this.in.get() != null) {
            this.in.get().clear();
        }
        this.in = null;
        if (this.out != null && this.out.get() != null) {
            this.out.get().clear();
        }
        this.out = null;
        Set docs = (Set)this.document.field("in");
        if (docs != null) {
            for (ODocument doc : docs.toArray(new ODocument[docs.size()])) {
                OGraphEdge.delete(this.database, doc);
            }
        }
        if ((docs = (Set)this.document.field("out")) != null) {
            for (ODocument doc : docs.toArray(new ODocument[docs.size()])) {
                OGraphEdge.delete(this.database, doc);
            }
        }
        this.database.unregisterPojo(this, this.document);
        this.document.delete();
        this.document = null;
    }

    @Override
    public void onEvent(ORecord<?> iDocument, ORecordListener.EVENT iEvent) {
        if (iEvent == ORecordListener.EVENT.UNLOAD) {
            this.out = null;
            this.in = null;
        }
    }

    public static void unlink(ODatabaseGraphTx iDatabase, ODocument iSourceVertex, ODocument iTargetVertex) {
        OGraphVertex vertex;
        if (iTargetVertex == null) {
            throw new IllegalArgumentException("Missed the target vertex");
        }
        if (iDatabase.existsUserObjectByRID(iSourceVertex.getIdentity())) {
            vertex = (OGraphVertex)iDatabase.getUserObjectByRecord(iSourceVertex, null);
            if (vertex.out != null && vertex.out.get() != null) {
                for (OGraphEdge e : vertex.out.get()) {
                    if (!e.getIn().getDocument().equals(iTargetVertex)) continue;
                    vertex.out.get().remove(e);
                }
            }
        }
        if (iDatabase.existsUserObjectByRID(iTargetVertex.getIdentity())) {
            vertex = (OGraphVertex)iDatabase.getUserObjectByRecord(iTargetVertex, null);
            if (vertex.in != null && vertex.in.get() != null) {
                for (OGraphEdge e : vertex.in.get()) {
                    if (!e.getOut().getDocument().equals(iSourceVertex)) continue;
                    vertex.in.get().remove(e);
                }
            }
        }
        ArrayList<ODocument> edges2Remove = new ArrayList<ODocument>();
        ODocument edge = null;
        Set docs = (Set)iSourceVertex.field("out");
        if (docs != null) {
            for (ODocument d : docs) {
                if (!((ODocument)d.field("in")).equals(iTargetVertex)) continue;
                edges2Remove.add(d);
                edge = d;
            }
            for (ODocument d : edges2Remove) {
                docs.remove(d);
            }
        }
        if (edge == null) {
            throw new OGraphException("Edge not found between the ougoing edges");
        }
        iSourceVertex.setDirty();
        iSourceVertex.save();
        docs = (Set)iTargetVertex.field("in");
        if (docs != null) {
            edges2Remove.clear();
            for (ODocument d : docs) {
                if (!((ODocument)d.field("in")).equals(iTargetVertex)) continue;
                edges2Remove.add(d);
            }
            for (ODocument d : edges2Remove) {
                docs.remove(d);
            }
        }
        iTargetVertex.setDirty();
        iTargetVertex.save();
        edge.delete();
    }
}

