/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.object;

import com.orientechnologies.orient.core.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.core.db.object.OLazyObjectIterator;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLazyObjectSet<TYPE>
implements Set<Object>,
Serializable {
    private static final long serialVersionUID = -2497274705163041241L;
    private final ORecord<?> sourceRecord;
    private transient ODatabasePojoAbstract<TYPE> database;
    private final Collection<Object> underlying;
    private String fetchPlan;
    private boolean converted = false;
    private boolean convertToRecord = true;

    public OLazyObjectSet(ODatabasePojoAbstract<TYPE> database, ORecord<?> iSourceRecord, Collection<Object> iSource) {
        this.database = database;
        this.sourceRecord = iSourceRecord;
        this.underlying = iSource;
    }

    @Override
    public Iterator<Object> iterator() {
        return new OLazyObjectIterator<Object>(this.database, this.sourceRecord, this.underlying.iterator(), this.convertToRecord);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlying.contains(this.database.getRecordByUserObject(o, false));
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.underlying.toArray(a);
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.database.getUserObjectByRecord((ORecordInternal)a[i], this.fetchPlan);
        }
        return a;
    }

    @Override
    public boolean add(Object e) {
        if (this.converted && e instanceof ORID) {
            this.converted = false;
        }
        this.setDirty();
        return this.underlying.add(this.database.getRecordByUserObject(e, false));
    }

    @Override
    public boolean remove(Object o) {
        this.setDirty();
        return this.underlying.remove(this.database.getRecordByUserObject(o, false));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.underlying.contains(this.database.getRecordByUserObject(o, false))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        boolean modified = false;
        this.setDirty();
        for (Object object : c) {
            if (this.underlying.add(this.database.getRecordByUserObject(object, false))) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.setDirty();
        return this.underlying.retainAll(c);
    }

    @Override
    public void clear() {
        this.setDirty();
        this.underlying.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.setDirty();
        boolean modified = false;
        for (Object o : c) {
            if (this.underlying.remove(this.database.getRecordByUserObject(o, false))) continue;
            modified = true;
        }
        return modified;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public OLazyObjectSet<TYPE> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }

    public boolean isConvertToRecord() {
        return this.convertToRecord;
    }

    public void setConvertToRecord(boolean convertToRecord) {
        this.convertToRecord = convertToRecord;
    }

    public String toString() {
        return this.underlying.toString();
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    public void assignDatabase(ODatabasePojoAbstract<TYPE> iDatabase) {
        if (this.database == null || this.database.isClosed()) {
            this.database = iDatabase;
        }
    }

    public void detach() {
        this.convertAll();
    }

    protected void convertAll() {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        HashSet<Object> copy = new HashSet<Object>(this);
        this.underlying.clear();
        for (Object e : copy) {
            if (e == null) continue;
            if (e instanceof ORID) {
                this.add(this.database.getUserObjectByRecord((ORecordInternal)((ODatabaseRecord)this.database.getUnderlying()).load((ORID)e, this.fetchPlan), this.fetchPlan));
                continue;
            }
            if (!(e instanceof ODocument)) continue;
            this.add(this.database.getUserObjectByRecord((ORecordInternal)e, this.fetchPlan));
        }
        this.converted = true;
    }
}

