/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLevel1RecordCache;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseWrapperAbstract;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.hook.OHookThreadLocal;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OPropertyIndexManager;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.security.OUserTrigger;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.query.OQueryAbstract;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODatabaseRecordAbstract
extends ODatabaseWrapperAbstract<ODatabaseRaw>
implements ODatabaseRecord {
    private OMetadata metadata;
    private OUser user;
    private static final String DEF_RECORD_FORMAT = "csv";
    private byte recordType;
    private String recordFormat;
    private Set<ORecordHook> hooks = new HashSet<ORecordHook>();
    private final Set<ORecordHook> unmodifiableHooks;
    private boolean retainRecords = true;
    private OLevel1RecordCache level1Cache;
    private boolean mvcc;
    private ODictionary<ORecordInternal<?>> dictionary;

    public ODatabaseRecordAbstract(String iURL, byte iRecordType) {
        super(new ODatabaseRaw(iURL));
        ((ODatabaseRaw)this.underlying).setOwner(this);
        this.unmodifiableHooks = Collections.unmodifiableSet(this.hooks);
        this.databaseOwner = this;
        this.recordType = iRecordType;
        this.level1Cache = new OLevel1RecordCache(this);
        this.mvcc = OGlobalConfiguration.DB_MVCC.getValueAsBoolean();
        this.setCurrentDatabaseinThreadLocal();
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        this.setCurrentDatabaseinThreadLocal();
        try {
            super.open(iUserName, iUserPassword);
            this.level1Cache.startup();
            this.metadata = new OMetadata(this);
            this.metadata.load();
            this.recordFormat = DEF_RECORD_FORMAT;
            this.user = this.getMetadata().getSecurity().authenticate(iUserName, iUserPassword);
            if (this.getStorage() instanceof OStorageEmbedded) {
                this.registerHook(new OUserTrigger());
                this.registerHook(new OPropertyIndexManager());
            }
            this.checkSecurity("database", 2);
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new ODatabaseException("Can't open database", e);
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB create() {
        this.setCurrentDatabaseinThreadLocal();
        try {
            super.create();
            this.level1Cache.startup();
            this.getStorage().getConfiguration().update();
            if (this.getStorage() instanceof OStorageEmbedded) {
                this.registerHook(new OUserTrigger());
                this.registerHook(new OPropertyIndexManager());
            }
            this.metadata = new OMetadata(this);
            this.metadata.create();
            this.user = this.getMetadata().getSecurity().getUser("admin");
        }
        catch (Exception e) {
            throw new ODatabaseException("Can't create database", e);
        }
        return (DB)this;
    }

    @Override
    public void close() {
        this.setCurrentDatabaseinThreadLocal();
        if (this.metadata != null) {
            this.metadata.close();
            this.metadata = null;
        }
        super.close();
        this.hooks.clear();
        this.dictionary = null;
        this.user = null;
        this.level1Cache.shutdown();
    }

    @Override
    public ODictionary<ORecordInternal<?>> getDictionary() {
        this.checkOpeness();
        if (this.dictionary == null) {
            this.dictionary = this.metadata.getIndexManager().getDictionary();
        }
        return this.dictionary;
    }

    @Override
    public <RET extends ORecordInternal<?>> RET getRecord(OIdentifiable iIdentifiable) {
        if (iIdentifiable instanceof ORecord) {
            return (RET)((ORecordInternal)iIdentifiable);
        }
        return (RET)this.load(iIdentifiable.getIdentity());
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord) {
        return this.load(iRecord, (String)null);
    }

    public void reload(ORecordInternal<?> iRecord) {
        this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, null, true);
    }

    public void reload(ORecordInternal<?> iRecord, String iFetchPlan) {
        this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, true);
    }

    @Override
    public void reload(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId) {
        return this.executeReadRecord((ORecordId)iRecordId, null, null, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, iIgnoreCache);
    }

    public ODatabaseRecord save(ORecordInternal<?> iContent) {
        this.executeSaveRecord(iContent, null, iContent.getVersion(), iContent.getRecordType());
        return this;
    }

    public ODatabaseRecord save(ORecordInternal<?> iContent, String iClusterName) {
        this.executeSaveRecord(iContent, iClusterName, iContent.getVersion(), iContent.getRecordType());
        return this;
    }

    public ODatabaseRecord delete(ORecordInternal<?> iRecord) {
        this.executeDeleteRecord(iRecord, -1);
        return this;
    }

    @Override
    public <REC extends ORecordInternal<?>> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iClass) {
        this.checkSecurity("database.cluster", 2, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId);
    }

    public ORecordIteratorCluster<?> browseCluster(String iClusterName) {
        this.checkSecurity("database.cluster", 2, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId);
    }

    @Override
    public OCommandRequest command(OCommandRequest iCommand) {
        this.setCurrentDatabaseinThreadLocal();
        OCommandRequestInternal command = (OCommandRequestInternal)iCommand;
        try {
            command.reset();
            command.setDatabase(this);
            return command;
        }
        catch (Exception e) {
            throw new ODatabaseException("Error on command execution", e);
        }
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<? extends Object> iCommand, Object ... iArgs) {
        this.setCurrentDatabaseinThreadLocal();
        iCommand.reset();
        if (iCommand instanceof OQueryAbstract) {
            ((OQueryAbstract)iCommand).setDatabase(this);
        }
        return (RET)((List)iCommand.execute(iArgs));
    }

    @Override
    public byte getRecordType() {
        return this.recordType;
    }

    @Override
    public <RET> RET newInstance() {
        return (RET)Orient.instance().getRecordFactoryManager().newInstance(this, this.recordType);
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        for (int i = 0; i < iClusterIds.length; ++i) {
            String name = this.getClusterNameById(iClusterIds[i]);
            this.checkSecurity("database.cluster", 2, (Object)name);
        }
        return super.countClusterElements(iClusterIds);
    }

    @Override
    public long countClusterElements(int iClusterId) {
        String name = this.getClusterNameById(iClusterId);
        this.checkSecurity("database.cluster", 2, (Object)name);
        this.setCurrentDatabaseinThreadLocal();
        return super.countClusterElements(name);
    }

    @Override
    public long countClusterElements(String iClusterName) {
        this.checkSecurity("database.cluster", 2, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        return super.countClusterElements(iClusterName);
    }

    @Override
    public OMetadata getMetadata() {
        this.checkOpeness();
        return this.metadata;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResource, int iOperation) {
        if (this.user != null) {
            try {
                this.user.allow(iResource, iOperation);
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', operation '%s'", new Object[]{this.getUser(), iResource, iOperation});
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        if (this.user != null) {
            try {
                StringBuilder keyBuffer = new StringBuilder();
                boolean ruleFound = false;
                for (Object target : iResourcesSpecific) {
                    if (target == null) continue;
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append(target.toString());
                    String key = keyBuffer.toString();
                    if (!this.user.isRuleDefined(key)) continue;
                    ruleFound = true;
                    this.user.allow(key, iOperation);
                }
                if (!ruleFound) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append("*");
                    this.user.allow(keyBuffer.toString(), iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', target(s) '%s', operation '%s'", new Object[]{this.getUser(), iResourceGeneric, Arrays.toString(iResourcesSpecific), iOperation});
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResourceGeneric, int iOperation, Object iResourceSpecific) {
        if (this.user != null) {
            try {
                StringBuilder keyBuffer = new StringBuilder();
                boolean ruleFound = false;
                if (iResourceSpecific != null) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append(iResourceSpecific.toString());
                    String key = keyBuffer.toString();
                    if (this.user.isRuleDefined(key)) {
                        ruleFound = true;
                        this.user.allow(key, iOperation);
                    }
                }
                if (!ruleFound) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append("*");
                    this.user.allow(keyBuffer.toString(), iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', target '%s', operation '%s'", new Object[]{this.getUser(), iResourceGeneric, iResourceSpecific, iOperation});
                }
                throw e;
            }
        }
        return (DB)this;
    }

    public <RET extends ORecordInternal<?>> RET executeReadRecord(ORecordId iRid, ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpeness();
        this.setCurrentDatabaseinThreadLocal();
        try {
            ODatabaseRecord currDb;
            this.checkSecurity("database.cluster", 2, (Object)this.getClusterNameById(iRid.getClusterId()));
            ORecordInternal<?> record = this.getTransaction().getRecord(iRid);
            if (record == null && !iIgnoreCache) {
                record = this.getLevel1Cache().findRecord(iRid);
            }
            if (record != null) {
                OFetchHelper.checkFetchPlanValid(iFetchPlan);
                this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, record);
                if (record.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record.reload();
                }
                this.callbackHooks(ORecordHook.TYPE.AFTER_READ, record);
                return (RET)record;
            }
            ORawBuffer recordBuffer = ((ODatabaseRaw)this.underlying).read(iRid, iFetchPlan);
            if (recordBuffer == null) {
                return null;
            }
            if (iRecord == null || iRecord.getRecordType() != recordBuffer.recordType) {
                iRecord = Orient.instance().getRecordFactoryManager().newInstance(this, recordBuffer.recordType);
            }
            if ((currDb = iRecord.getDatabase()) == null) {
                currDb = (ODatabaseRecord)this.databaseOwner;
            }
            iRecord.fill(currDb, iRid, recordBuffer.version, recordBuffer.buffer, false);
            this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, iRecord);
            iRecord.fromStream(recordBuffer.buffer);
            iRecord.setInternalStatus(ORecordElement.STATUS.LOADED);
            this.callbackHooks(ORecordHook.TYPE.AFTER_READ, iRecord);
            if (!iIgnoreCache) {
                this.getLevel1Cache().updateRecord(iRecord);
            }
            return (RET)iRecord;
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on retrieving record " + iRid, e, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    public void executeSaveRecord(ORecordInternal<?> iRecord, String iClusterName, int iVersion, byte iRecordType) {
        this.checkOpeness();
        if (!iRecord.isDirty()) {
            return;
        }
        ORecordId rid = (ORecordId)iRecord.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Can't create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        this.setCurrentDatabaseinThreadLocal();
        if (iRecord.getDatabase() == null) {
            iRecord.setDatabase(this);
        }
        try {
            boolean wasNew = rid.isNew();
            byte[] stream = iRecord.toStream();
            boolean isNew = rid.isNew();
            if (isNew) {
                iRecord.onBeforeIdentityChanged(rid);
            } else if (stream.length == 0) {
                return;
            }
            if (isNew && rid.clusterId < 0) {
                int n = rid.clusterId = iClusterName != null ? this.getClusterIdByName(iClusterName) : this.getDefaultClusterId();
            }
            if (stream != null && stream.length > 0) {
                if (wasNew) {
                    this.checkSecurity("database.cluster", 1, (Object)iClusterName);
                    if (this.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, iRecord)) {
                        stream = iRecord.toStream();
                    }
                } else {
                    this.checkSecurity("database.cluster", 4, (Object)iClusterName);
                    if (this.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, iRecord)) {
                        stream = iRecord.toStream();
                    }
                }
                if (!iRecord.isDirty()) {
                    this.getLevel1Cache().updateRecord(iRecord);
                    return;
                }
            }
            int realVersion = iVersion == -1 || !this.mvcc ? -1 : iRecord.getVersion();
            long result = ((ODatabaseRaw)this.underlying).save(rid, stream, realVersion, iRecord.getRecordType());
            if (isNew) {
                ((ORecordId)iRecord.getIdentity()).copyFrom(rid);
                iRecord.onAfterIdentityChanged(iRecord);
            }
            if (isNew) {
                iRecord.fill(iRecord.getDatabase(), rid, 0, stream, stream == null || stream.length == 0);
            } else {
                iRecord.fill(iRecord.getDatabase(), rid, (int)result, stream, stream == null || stream.length == 0);
            }
            this.callbackHooks(wasNew ? ORecordHook.TYPE.AFTER_CREATE : ORecordHook.TYPE.AFTER_UPDATE, iRecord);
            if (stream != null && stream.length > 0) {
                this.getLevel1Cache().updateRecord(iRecord);
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on saving record in cluster #" + iRecord.getIdentity().getClusterId(), t);
        }
    }

    public void executeDeleteRecord(OIdentifiable iRecord, int iVersion) {
        this.checkOpeness();
        ORecordId rid = (ORecordId)iRecord.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Can't delete record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return;
        }
        this.checkSecurity("database.cluster", 8, (Object)this.getClusterNameById(rid.clusterId));
        this.setCurrentDatabaseinThreadLocal();
        try {
            this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, iRecord);
            ((ODatabaseRaw)this.underlying).delete(rid, iVersion);
            this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, iRecord);
            this.getLevel1Cache().deleteRecord(rid);
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on deleting record in cluster #" + iRecord.getIdentity().getClusterId(), t);
        }
    }

    @Override
    public ODatabaseComplex<?> getDatabaseOwner() {
        ODatabaseComplex<?> current;
        for (current = this.databaseOwner; current != null && current != this && current.getDatabaseOwner() != current; current = current.getDatabaseOwner()) {
        }
        return current;
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> setDatabaseOwner(ODatabaseComplex<?> iOwner) {
        this.databaseOwner = iOwner;
        return this;
    }

    @Override
    public boolean isRetainRecords() {
        return this.retainRecords;
    }

    @Override
    public ODatabaseRecord setRetainRecords(boolean retainRecords) {
        this.retainRecords = retainRecords;
        return this;
    }

    @Override
    public <DB extends ODatabase> DB setStatus(ODatabase.STATUS status) {
        String cmd = String.format("alter database status %s", status.toString());
        this.command(new OCommandSQL(cmd)).execute(new Object[0]);
        return (DB)this;
    }

    public void setStatusInternal(ODatabase.STATUS status) {
        ((ODatabaseRaw)this.underlying).setStatus(status);
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (iAttribute) {
            case STATUS: {
                this.setStatusInternal(ODatabase.STATUS.valueOf(stringValue.toUpperCase()));
            }
        }
    }

    @Override
    public OUser getUser() {
        return this.user;
    }

    @Override
    public boolean isMVCC() {
        return this.mvcc;
    }

    @Override
    public ODatabaseRecord setMVCC(boolean mvcc) {
        this.mvcc = mvcc;
        return this;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB registerHook(ORecordHook iHookImpl) {
        this.hooks.add(iHookImpl);
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB unregisterHook(ORecordHook iHookImpl) {
        this.hooks.remove(iHookImpl);
        return (DB)this;
    }

    @Override
    public OLevel1RecordCache getLevel1Cache() {
        return this.level1Cache;
    }

    @Override
    public Set<ORecordHook> getHooks() {
        return this.unmodifiableHooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean callbackHooks(ORecordHook.TYPE iType, OIdentifiable iRecord) {
        boolean bl;
        if (!OHookThreadLocal.INSTANCE.push(iRecord)) {
            return false;
        }
        try {
            boolean recordChanged = false;
            for (ORecordHook hook : this.hooks) {
                if (!hook.onTrigger(iType, (ORecord)iRecord)) continue;
                recordChanged = true;
            }
            bl = recordChanged;
            Object var7_7 = null;
            OHookThreadLocal.INSTANCE.pop(iRecord);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OHookThreadLocal.INSTANCE.pop(iRecord);
            throw throwable;
        }
        return bl;
    }

    protected ORecordSerializer resolveFormat(Object iObject) {
        return ORecordSerializerFactory.instance().getFormatForObject(iObject, this.recordFormat);
    }

    @Override
    protected void checkOpeness() {
        if (this.isClosed()) {
            throw new ODatabaseException("Database is closed");
        }
    }

    protected void setCurrentDatabaseinThreadLocal() {
        ODatabaseRecordThreadLocal.INSTANCE.set(this);
    }
}

