/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLazyRecordIterator
implements Iterator<OIdentifiable> {
    private final ODatabaseRecord sourceDatabase;
    private final ORecord<?> sourceRecord;
    private final Iterator<? extends OIdentifiable> underlying;
    private final boolean autoConvert2Record;

    public OLazyRecordIterator(ORecord<?> iSourceRecord, ODatabaseRecord iSourceDatabase, byte iRecordType, Iterator<? extends OIdentifiable> iIterator, boolean iConvertToRecord) {
        this.sourceRecord = iSourceRecord;
        this.sourceDatabase = iSourceDatabase;
        this.underlying = iIterator;
        this.autoConvert2Record = iConvertToRecord;
    }

    @Override
    public OIdentifiable next() {
        OIdentifiable value = this.underlying.next();
        if (value == null) {
            return null;
        }
        if (this.sourceDatabase != null && value instanceof ORecordId && this.autoConvert2Record) {
            return (OIdentifiable)this.sourceDatabase.load((ORecordId)value);
        }
        return value;
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public void remove() {
        this.underlying.remove();
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }
}

