/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OLazyRecordIterator;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordMultiValueHelper;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordLazyMap
extends OTrackedMap<OIdentifiable>
implements ORecordLazyMultiValue {
    private ODatabaseRecord database;
    private final byte recordType;
    private ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE status = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
    private boolean autoConvertToRecord = true;

    public ORecordLazyMap(ORecord<?> iSourceRecord, byte iRecordType) {
        super(iSourceRecord);
        this.database = iSourceRecord.getDatabase();
        this.recordType = iRecordType;
    }

    @Override
    public boolean containsValue(Object o) {
        return super.containsValue(o);
    }

    @Override
    public OIdentifiable get(Object iKey) {
        if (iKey == null) {
            return null;
        }
        String key = iKey.toString();
        this.convertLink2Record(key);
        return (OIdentifiable)super.get(key);
    }

    @Override
    public OIdentifiable put(Object iKey, OIdentifiable iValue) {
        if (this.status == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS && iValue instanceof ORecord && !((ORecord)iValue).getIdentity().isNew()) {
            iValue = ((ORecord)iValue).getIdentity();
        } else {
            this.status = ORecordMultiValueHelper.updateContentType(this.status, iValue);
        }
        return super.put(iKey, iValue);
    }

    @Override
    public Collection<OIdentifiable> values() {
        this.convertLinks2Records();
        return super.values();
    }

    @Override
    public OIdentifiable remove(Object o) {
        OIdentifiable result = (OIdentifiable)super.remove(o);
        if (this.size() == 0) {
            this.status = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.status = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
    }

    @Override
    public String toString() {
        return ORecordMultiValueHelper.toString(this);
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.autoConvertToRecord = convertToRecord;
    }

    @Override
    public void convertLinks2Records() {
        if (this.status == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS || !this.autoConvertToRecord || this.database == null) {
            return;
        }
        for (Object k : this.keySet()) {
            this.convertLink2Record(k);
        }
        this.status = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS;
    }

    @Override
    public boolean convertRecords2Links() {
        if (this.status == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS || this.database == null) {
            return true;
        }
        boolean allConverted = true;
        for (Object k : this.keySet()) {
            if (this.convertRecord2Link(k)) continue;
            allConverted = false;
        }
        if (allConverted) {
            this.status = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS;
        }
        return allConverted;
    }

    private boolean convertRecord2Link(Object iKey) {
        if (this.status == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS || this.database == null) {
            return true;
        }
        Object value = super.get(iKey);
        if (value != null) {
            if (value instanceof ORecord && !((ORecord)value).getIdentity().isNew()) {
                if (((ORecord)value).isDirty()) {
                    this.database.save((ORecordInternal)value);
                }
                super.put(iKey, ((ORecord)value).getIdentity());
                return true;
            }
            if (value instanceof ORID) {
                return true;
            }
        }
        return false;
    }

    private void convertLink2Record(Object iKey) {
        if (this.status == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS || this.database == null) {
            return;
        }
        Object value = iKey instanceof ORID ? iKey : super.get(iKey);
        if (value != null && value instanceof ORID) {
            ORID rid = (ORID)value;
            try {
                ORecord record = (ORecord)this.database.load(rid);
                super.put(iKey, record);
            }
            catch (ORecordNotFoundException e) {
                // empty catch block
            }
        }
    }

    public byte getRecordType() {
        return this.recordType;
    }

    @Override
    public boolean setDatabase(ODatabaseRecord iDatabase) {
        if (this.database != iDatabase) {
            this.database = iDatabase;
            super.setDatabase(iDatabase);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        return new OLazyRecordIterator(this.sourceRecord, this.database, this.recordType, super.values().iterator(), false);
    }
}

