/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTrackedList<T>
extends ArrayList<T>
implements ORecordElement {
    protected final ORecordInternal<?> sourceRecord;
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;

    public OTrackedList(ORecordInternal<?> iSourceRecord) {
        this.sourceRecord = iSourceRecord;
    }

    @Override
    public boolean add(T element) {
        this.setDirty();
        return super.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.setDirty();
        for (T o : c) {
            this.rawAdd(o);
        }
        return true;
    }

    @Override
    public void add(int index, T element) {
        this.setDirty();
        super.add(index, element);
    }

    @Override
    public T set(int index, T element) {
        this.setDirty();
        return super.set(index, element);
    }

    @Override
    public T remove(int index) {
        this.setDirty();
        return (T)super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.setDirty();
        return super.remove(o);
    }

    @Override
    public void clear() {
        this.setDirty();
        super.clear();
    }

    public void reset() {
        super.clear();
    }

    @Override
    public <RET> RET setDirty() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null && !this.sourceRecord.isDirty()) {
            this.sourceRecord.setDirty();
        }
        return (RET)this;
    }

    @Override
    public void onBeforeIdentityChanged(ORID iRID) {
    }

    @Override
    public void onAfterIdentityChanged(ORecord<?> iRecord) {
    }

    @Override
    public boolean setDatabase(ODatabaseRecord iDatabase) {
        if (this.sourceRecord != null) {
            return this.sourceRecord.setDatabase(iDatabase);
        }
        return false;
    }

    protected boolean rawAdd(T element) {
        return super.add(element);
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }
}

