/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLogical;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseExport
extends ODatabaseImpExpAbstract {
    private OJSONWriter writer;
    private long recordExported;
    public static final int VERSION = 1;

    public ODatabaseExport(ODatabaseRecord iDatabase, String iFileName, OCommandOutputListener iListener) throws IOException {
        super(iDatabase, iFileName, iListener);
        if (!this.fileName.endsWith(".gz")) {
            this.fileName = this.fileName + ".gz";
        }
        File f = new File(this.fileName);
        f.mkdirs();
        if (f.exists()) {
            f.delete();
        }
        this.writer = new OJSONWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.fileName))));
        this.writer.beginObject();
        iDatabase.getLevel1Cache().setEnable(false);
        iDatabase.getLevel2Cache().setEnable(false);
    }

    public ODatabaseExport(ODatabaseRecord iDatabase, OutputStream iOutputStream, OCommandOutputListener iListener) throws IOException {
        super(iDatabase, "streaming", iListener);
        this.writer = new OJSONWriter(new OutputStreamWriter(iOutputStream));
        this.writer.beginObject();
        iDatabase.getLevel1Cache().setEnable(false);
        iDatabase.getLevel2Cache().setEnable(false);
    }

    public ODatabaseExport exportDatabase() {
        try {
            try {
                this.listener.onMessage("\nStarted export of database '" + this.database.getName() + "' to " + this.fileName + "...");
                this.database.getLevel1Cache().setEnable(false);
                this.database.getLevel2Cache().setEnable(false);
                long time = System.currentTimeMillis();
                if (this.includeInfo) {
                    this.exportInfo();
                }
                this.exportClusters();
                if (this.includeSchema) {
                    this.exportSchema();
                }
                this.exportRecords();
                if (this.includeIndexes) {
                    this.exportIndexes();
                }
                this.listener.onMessage("\n\nDatabase export completed in " + (System.currentTimeMillis() - time) + "ms");
                this.writer.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ODatabaseExportException("Error on exporting database '" + this.database.getName() + "' to: " + this.fileName, e);
            }
            Object var4_3 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.close();
            throw throwable;
        }
        return this;
    }

    public long exportRecords() throws IOException {
        long totalRecords = 0L;
        int level = 1;
        this.listener.onMessage("\nExporting records...");
        this.writer.beginCollection(level, true, "records");
        int exportedClusters = 0;
        int maxClusterId = this.getMaxClusterId();
        int i = 0;
        while (exportedClusters <= maxClusterId) {
            block7: {
                long recordTot;
                String clusterName;
                block8: {
                    block6: {
                        clusterName = this.database.getClusterNameById(i);
                        ++exportedClusters;
                        if (clusterName == null) break block6;
                        if (this.includeClusters == null ? this.excludeClusters != null && this.excludeClusters.contains(clusterName) : !this.includeClusters.contains(clusterName)) break block7;
                        if (this.excludeClusters.contains(clusterName)) break block7;
                        recordTot = this.database.countClusterElements(clusterName);
                        break block8;
                    }
                    recordTot = 0L;
                }
                this.listener.onMessage("\n- Cluster " + (clusterName != null ? "'" + clusterName + "'" : "NULL") + " (id=" + i + ")...");
                long recordNum = 0L;
                if (clusterName != null) {
                    ORecordIteratorCluster it = this.database.browseCluster(clusterName);
                    while (it.hasNext()) {
                        Object rec = null;
                        try {
                            rec = it.next();
                            if (rec instanceof ODocument) {
                                ODocument doc = (ODocument)rec;
                                if (this.includeClasses != null ? !this.includeClasses.contains(doc.getClassName()) : this.excludeClasses != null && this.excludeClasses.contains(doc.getClassName())) continue;
                            }
                            this.exportRecord(recordTot, recordNum++, (ORecordInternal<?>)rec);
                        }
                        catch (Throwable t) {
                            if (rec == null) continue;
                            byte[] buffer = rec.toStream();
                            OLogManager.instance().error((Object)this, "Error on exporting record #%s. It seems corrupted; size: %d bytes, raw content (as string):\n==========\n%s\n==========", t, new Object[]{rec.getIdentity(), buffer.length, new String(buffer)});
                        }
                    }
                }
                this.listener.onMessage("OK (records=" + recordTot + ")");
                totalRecords += recordTot;
            }
            ++i;
        }
        this.writer.endCollection(level, true);
        this.listener.onMessage("\n\nDone. Exported " + totalRecords + " records\n");
        return totalRecords;
    }

    public void close() {
        this.database.declareIntent(null);
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.endObject();
            this.writer.close();
            this.writer = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void exportClusters() throws IOException {
        this.listener.onMessage("\nExporting clusters...");
        this.writer.beginCollection(1, true, "clusters");
        int exportedClusters = 0;
        int maxClusterId = this.getMaxClusterId();
        for (int clusterId = 0; clusterId <= maxClusterId; ++clusterId) {
            String clusterName = this.database.getClusterNameById(clusterId);
            if (clusterName != null && (this.includeClusters != null ? !this.includeClusters.contains(clusterName) : this.excludeClusters != null && this.excludeClusters.contains(clusterName))) continue;
            this.writer.beginObject(2, true, null);
            this.writer.writeAttribute(0, false, "name", clusterName != null ? clusterName : "");
            this.writer.writeAttribute(0, false, "id", clusterId);
            this.writer.writeAttribute(0, false, "type", clusterName != null ? this.database.getClusterType(clusterName) : "");
            if (clusterName != null && this.database.getStorage() instanceof OStorageLocal && this.database.getClusterType(clusterName).equals("LOGICAL")) {
                OClusterLogical cluster = (OClusterLogical)this.database.getStorage().getClusterById(clusterId);
                this.writer.writeAttribute(0, false, "rid", cluster.getRID());
            }
            ++exportedClusters;
            this.writer.endObject(2, false);
        }
        this.listener.onMessage("OK (" + exportedClusters + " clusters)");
        this.writer.endCollection(1, true);
    }

    protected int getMaxClusterId() {
        int totalCluster = -1;
        for (String clusterName : this.database.getClusterNames()) {
            if (this.database.getClusterIdByName(clusterName) <= totalCluster) continue;
            totalCluster = this.database.getClusterIdByName(clusterName);
        }
        return totalCluster;
    }

    private void exportInfo() throws IOException {
        this.listener.onMessage("\nExporting database info...");
        this.writer.beginObject(1, true, "info");
        this.writer.writeAttribute(2, true, "name", this.database.getName().replace('\\', '/'));
        this.writer.writeAttribute(2, true, "default-cluster-id", this.database.getDefaultClusterId());
        this.writer.writeAttribute(2, true, "exporter-version", 1);
        this.writer.writeAttribute(2, true, "engine-version", "1.0rc5");
        String engineBuild = OConstants.getBuildNumber();
        if (engineBuild != null) {
            this.writer.writeAttribute(2, true, "engine-build", engineBuild);
        }
        this.writer.writeAttribute(2, true, "storage-config-version", 2);
        this.writer.writeAttribute(2, true, "schema-version", 4);
        this.writer.writeAttribute(2, true, "mvrbtree-version", (byte)0);
        this.writer.endObject(1, true);
        this.listener.onMessage("OK");
    }

    private void exportIndexes() throws IOException {
        this.listener.onMessage("\nExporting indexes...");
        this.writer.beginObject(1, true, "indexes");
        for (OIndex<?> i : this.database.getMetadata().getIndexManager().getIndexes()) {
            if (i == null || i.isAutomatic()) continue;
            long tot = 0L;
            this.listener.onMessage("\n- Index '" + i.getName() + "' [" + i.getType() + "]...");
            this.writer.beginObject(2, true, i.getName());
            Iterator<Map.Entry<Object, ?>> iterator = i.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, ?> entry = iterator.next();
                this.writer.writeAttribute(3, true, "key", entry.getKey());
                this.writer.writeAttribute(0, false, "value", OJSONWriter.writeValue(entry.getValue()));
                ++tot;
            }
            this.listener.onMessage("OK (entries=" + tot + ")");
            this.writer.endObject(2, true);
        }
        this.writer.endObject(1, true);
    }

    private void exportSchema() throws IOException {
        this.listener.onMessage("\nExporting schema...");
        this.writer.beginObject(1, true, "schema");
        OSchemaProxy s = (OSchemaProxy)this.database.getMetadata().getSchema();
        this.writer.writeAttribute(2, true, "version", s.getVersion());
        if (s.getClasses().size() > 0) {
            this.writer.beginCollection(2, true, "classes");
            ArrayList<OClass> classes = new ArrayList<OClass>(s.getClasses());
            Collections.sort(classes);
            for (OClass cls : classes) {
                this.writer.beginObject(3, true, null);
                this.writer.writeAttribute(0, false, "name", cls.getName());
                this.writer.writeAttribute(0, false, "default-cluster-id", cls.getDefaultClusterId());
                this.writer.writeAttribute(0, false, "cluster-ids", cls.getClusterIds());
                if (cls.getSuperClass() != null) {
                    this.writer.writeAttribute(0, false, "super-class", cls.getSuperClass().getName());
                }
                if (cls.getShortName() != null) {
                    this.writer.writeAttribute(0, false, "short-name", cls.getShortName());
                }
                if (cls.properties().size() > 0) {
                    this.writer.beginCollection(4, true, "properties");
                    ArrayList<OProperty> properties = new ArrayList<OProperty>(cls.declaredProperties());
                    Collections.sort(properties);
                    for (OProperty p : properties) {
                        this.writer.beginObject(5, true, null);
                        this.writer.writeAttribute(0, false, "name", p.getName());
                        this.writer.writeAttribute(0, false, "type", p.getType().toString());
                        this.writer.writeAttribute(0, false, "mandatory", p.isMandatory());
                        this.writer.writeAttribute(0, false, "not-null", p.isNotNull());
                        if (p.getLinkedClass() != null) {
                            this.writer.writeAttribute(0, false, "linked-class", p.getLinkedClass().getName());
                        }
                        if (p.getLinkedType() != null) {
                            this.writer.writeAttribute(0, false, "linked-type", p.getLinkedType().toString());
                        }
                        if (p.getMin() != null) {
                            this.writer.writeAttribute(0, false, "min", p.getMin());
                        }
                        if (p.getMax() != null) {
                            this.writer.writeAttribute(0, false, "max", p.getMax());
                        }
                        if (p.getIndex() != null) {
                            this.writer.writeAttribute(0, false, "index", p.getIndex().getUnderlying().getName());
                        }
                        this.writer.endObject(0, false);
                    }
                    this.writer.endCollection(4, true);
                }
                this.writer.endObject(3, true);
            }
            this.writer.endCollection(2, true);
        }
        this.writer.endObject(1, true);
        this.listener.onMessage("OK (" + s.getClasses().size() + " classes)");
    }

    private void exportRecord(long recordTot, long recordNum, ORecordInternal<?> rec) throws IOException {
        if (rec == null) {
            return;
        }
        if (rec.getIdentity().isValid()) {
            rec.reload();
        }
        if (this.recordExported > 0L) {
            this.writer.append(",");
        }
        this.writer.append(rec.toJSON("rid,type,version,class,attribSameRow,indent:4,keepTypes"));
        ++this.recordExported;
        if (recordTot > 10L && (++recordNum + 1L) % (recordTot / 10L) == 0L) {
            this.listener.onMessage(".");
        }
    }
}

