/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.common.parser.OStringForwardReader;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONReader;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class ODatabaseImport
extends ODatabaseImpExpAbstract {
    private Map<OPropertyImpl, String> linkedClasses = new HashMap<OPropertyImpl, String>();
    private Map<OClass, String> superClasses = new HashMap<OClass, String>();
    private OJSONReader jsonReader;
    private OStringForwardReader reader;
    private ORecordInternal<?> record;
    private List<String> recordToDelete = new ArrayList<String>();
    private Map<OProperty, String> propertyIndexes = new HashMap<OProperty, String>();
    private boolean schemaImported = false;

    public ODatabaseImport(ODatabaseDocument database, String iFileName, OCommandOutputListener iListener) throws IOException {
        super(database, iFileName, iListener);
        InputStream inStream;
        try {
            inStream = new GZIPInputStream(new FileInputStream(this.fileName));
        }
        catch (Exception e) {
            inStream = new FileInputStream(this.fileName);
        }
        this.jsonReader = new OJSONReader(new InputStreamReader(inStream));
        database.declareIntent(new OIntentMassiveInsert());
    }

    public ODatabaseImport(ODatabaseDocument database, InputStream iStream, OCommandOutputListener iListener) throws IOException {
        super(database, "streaming", iListener);
        this.jsonReader = new OJSONReader(new InputStreamReader(iStream));
        database.declareIntent(new OIntentMassiveInsert());
    }

    public ODatabaseImport importDatabase() {
        try {
            try {
                this.listener.onMessage("\nStarted import of database '" + this.database.getURL() + "' from " + this.fileName + "...");
                long time = System.currentTimeMillis();
                this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
                this.database.getLevel1Cache().setEnable(false);
                this.database.getLevel2Cache().setEnable(false);
                this.database.setMVCC(false);
                this.database.setStatus(ODatabase.STATUS.IMPORTING);
                while (this.jsonReader.hasNext() && this.jsonReader.lastChar() != '}') {
                    String tag = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
                    if (tag.equals("info")) {
                        this.importInfo();
                        continue;
                    }
                    if (tag.equals("clusters")) {
                        this.importClusters();
                        continue;
                    }
                    if (tag.equals("schema")) {
                        this.importSchema();
                        continue;
                    }
                    if (tag.equals("records")) {
                        this.importRecords();
                        continue;
                    }
                    if (!tag.equals("indexes")) continue;
                    this.importManualIndexes();
                }
                this.deleteHoleRecords();
                this.rebuildAutomaticIndexes();
                this.database.setStatus(ODatabase.STATUS.OPEN);
                this.listener.onMessage("\n\nDatabase import completed in " + (System.currentTimeMillis() - time) + " ms");
            }
            catch (Exception e) {
                System.err.println("Error on database import happened just before line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber());
                e.printStackTrace();
                throw new ODatabaseExportException("Error on importing database '" + this.database.getName() + "' from file: " + this.fileName, e);
            }
            Object var5_4 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close();
            throw throwable;
        }
        return this;
    }

    private void rebuildAutomaticIndexes() {
        this.listener.onMessage("\nRebuilding " + this.propertyIndexes.size() + " automatic indexes...");
        this.database.getMetadata().getIndexManager().reload();
        for (Map.Entry<OProperty, String> e : this.propertyIndexes.entrySet()) {
            OIndex<?> idx = this.database.getMetadata().getIndexManager().getIndex(e.getValue());
            if (idx == null) continue;
            idx.setCallback(e.getKey().getIndex());
            this.listener.onMessage("\n- Index '" + idx.getName() + "'...");
            this.listener.onMessage("OK (" + idx.getSize() + " records)");
        }
    }

    private void deleteHoleRecords() {
        this.listener.onMessage("\nDelete temporary records...");
        ORecordId rid = new ORecordId();
        ODocument doc = new ODocument(this.database, rid);
        for (String recId : this.recordToDelete) {
            doc.reset();
            rid.fromString(recId);
            doc.delete();
        }
        this.listener.onMessage("OK (" + this.recordToDelete.size() + " records)");
    }

    private void importInfo() throws IOException, ParseException {
        this.listener.onMessage("\nImporting database info...");
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        int defClusterId = this.jsonReader.readNumber(OJSONReader.ANY_NUMBER, true);
        this.jsonReader.readNext(OJSONReader.END_OBJECT);
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        this.listener.onMessage("OK");
    }

    private void importManualIndexes() throws IOException, ParseException {
        this.listener.onMessage("\nImporting manual indexes...");
        ODocument doc = new ODocument(this.database);
        this.database.getMetadata().getIndexManager().load();
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        do {
            String indexName;
            if ((indexName = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT)) == null || indexName.length() == 0) {
                return;
            }
            this.listener.onMessage("\n- Index '" + indexName + "'...");
            OIndex<?> index = this.database.getMetadata().getIndexManager().getIndex(indexName);
            long tot = 0L;
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            do {
                this.jsonReader.readNext(new char[]{':', '}'});
                if (this.jsonReader.lastChar() == '}') continue;
                String key = this.jsonReader.checkContent("\"key\"").readString(OJSONReader.COMMA_SEPARATOR);
                String value = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"value\"").readString(OJSONReader.NEXT_IN_OBJECT);
                if (index != null && value.length() >= 4) {
                    if (value.charAt(0) == '[') {
                        value = value.substring(1, value.length() - 1);
                    }
                    List<String> rids = OStringSerializerHelper.split(value, ',', '#', '\"');
                    for (String rid : rids) {
                        doc.setIdentity(new ORecordId(rid));
                        index.put(key, doc);
                    }
                }
                ++tot;
            } while (this.jsonReader.lastChar() == ',');
            if (index != null) {
                this.listener.onMessage("OK (" + tot + " entries)");
            } else {
                this.listener.onMessage("KO, the index wasn't found in configuration");
            }
            this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
        } while (this.jsonReader.lastChar() == ',');
    }

    private void importSchema() throws IOException, ParseException {
        this.listener.onMessage("\nImporting database schema...");
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        int schemaVersion = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"version\"").readNumber(OJSONReader.ANY_NUMBER, true);
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR).readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"classes\"").readNext(OJSONReader.BEGIN_COLLECTION);
        long classImported = 0L;
        try {
            do {
                this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
                String className = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
                String string = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
                if (string.equals("\"id\"")) {
                    String string2 = this.jsonReader.readString(OJSONReader.COMMA_SEPARATOR);
                }
                String string3 = this.jsonReader.checkContent("\"default-cluster-id\"").readString(OJSONReader.NEXT_IN_OBJECT);
                int classDefClusterId = Integer.parseInt(string3);
                String classClusterIds = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"cluster-ids\"").readString(OJSONReader.NEXT_IN_OBJECT).trim();
                OClassImpl cls = (OClassImpl)this.database.getMetadata().getSchema().getClass(className);
                if (cls != null) {
                    if (cls.getDefaultClusterId() != classDefClusterId) {
                        cls.setDefaultClusterId(classDefClusterId);
                    }
                } else {
                    cls = (OClassImpl)this.database.getMetadata().getSchema().createClass(className, classDefClusterId);
                }
                if (classClusterIds != null) {
                    classClusterIds = classClusterIds.substring(1, classClusterIds.length() - 1);
                    for (int i : OStringSerializerHelper.splitIntArray(classClusterIds)) {
                        cls.addClusterIds(i);
                    }
                }
                while (this.jsonReader.lastChar() == ',') {
                    this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
                    String value = this.jsonReader.getValue();
                    if (value.equals("\"short-name\"")) {
                        String shortName = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        cls.setShortName(shortName);
                        continue;
                    }
                    if (value.equals("\"super-class\"")) {
                        String classSuper = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        this.superClasses.put(cls, classSuper);
                        continue;
                    }
                    if (!value.equals("\"properties\"")) continue;
                    this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
                    while (this.jsonReader.lastChar() != ']') {
                        this.importProperty(cls);
                        if (this.jsonReader.lastChar() != '}') continue;
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    }
                    this.jsonReader.readNext(OJSONReader.END_OBJECT);
                }
                ++classImported;
                this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            } while (this.jsonReader.lastChar() == ',');
            for (Map.Entry<OClass, String> entry : this.superClasses.entrySet()) {
                entry.getKey().setSuperClass(this.database.getMetadata().getSchema().getClass(entry.getValue()));
            }
            for (Map.Entry<Comparable<OClass>, String> entry : this.linkedClasses.entrySet()) {
                ((OPropertyImpl)entry.getKey()).setLinkedClass(this.database.getMetadata().getSchema().getClass(entry.getValue()));
            }
            this.listener.onMessage("OK (" + classImported + " classes)");
            this.schemaImported = true;
            this.jsonReader.readNext(OJSONReader.END_OBJECT);
            this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.listener.onMessage("ERROR (" + classImported + " entries): " + e);
        }
    }

    private void importProperty(OClass iClass) throws IOException, ParseException {
        this.jsonReader.readNext(OJSONReader.NEXT_OBJ_IN_ARRAY);
        if (this.jsonReader.lastChar() == ']') {
            return;
        }
        String propName = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
        String next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
        if (next.equals("\"id\"")) {
            next = this.jsonReader.readString(OJSONReader.COMMA_SEPARATOR);
        }
        next = this.jsonReader.checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT);
        OType type = OType.valueOf(next);
        String min = null;
        String max = null;
        String linkedClass = null;
        OType linkedType = null;
        String indexName = null;
        String indexType = null;
        boolean mandatory = false;
        boolean notNull = false;
        while (this.jsonReader.lastChar() == ',') {
            this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
            String attrib = this.jsonReader.getValue();
            String value = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
            if (attrib.equals("\"min\"")) {
                min = value;
                continue;
            }
            if (attrib.equals("\"max\"")) {
                max = value;
                continue;
            }
            if (attrib.equals("\"linked-class\"")) {
                linkedClass = value;
                continue;
            }
            if (attrib.equals("\"mandatory\"")) {
                mandatory = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"not-null\"")) {
                notNull = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"linked-type\"")) {
                linkedType = OType.valueOf(value);
                continue;
            }
            if (attrib.equals("\"index\"")) {
                indexName = value;
                continue;
            }
            if (!attrib.equals("\"index-type\"")) continue;
            indexType = value;
        }
        OPropertyImpl prop = (OPropertyImpl)iClass.getProperty(propName);
        if (prop == null) {
            prop = (OPropertyImpl)iClass.createProperty(propName, type);
        }
        prop.setMandatory(mandatory);
        prop.setNotNull(notNull);
        if (min != null) {
            prop.setMin(min);
        }
        if (max != null) {
            prop.setMax(max);
        }
        if (linkedClass != null) {
            this.linkedClasses.put(prop, linkedClass);
        }
        if (linkedType != null) {
            prop.setLinkedType(linkedType);
        }
        if (indexName != null) {
            this.propertyIndexes.put(prop, indexName);
        }
    }

    private long importClusters() throws ParseException, IOException {
        this.listener.onMessage("\nImporting clusters...");
        long total = 0L;
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        ORecordId rid = null;
        while (this.jsonReader.lastChar() != ']') {
            int clusterId;
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            String name = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
            if (name.length() == 0) {
                name = null;
            }
            if (name != null) {
                if (this.includeClusters != null) {
                    if (!this.includeClusters.contains(name)) {
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                        continue;
                    }
                } else if (this.excludeClusters != null && this.excludeClusters.contains(name)) {
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    continue;
                }
            }
            int id = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"id\"").readInteger(OJSONReader.COMMA_SEPARATOR);
            String type = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT);
            rid = this.jsonReader.lastChar() == ',' ? new ORecordId(this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"rid\"").readString(OJSONReader.NEXT_IN_OBJECT)) : null;
            this.listener.onMessage("\n- Creating cluster " + (name != null ? "'" + name + "'" : "NULL") + "...");
            int n = clusterId = name != null ? this.database.getClusterIdByName(name) : -1;
            if (clusterId == -1) {
                clusterId = type.equals("LOGICAL") ? this.database.addLogicalCluster(name, this.database.getClusterIdByName("internal")) : this.database.addPhysicalCluster(name, name, -1);
            }
            if (clusterId != id) {
                throw new OConfigurationException("Imported cluster '" + name + "' has id=" + clusterId + " different from the original: " + id);
            }
            this.listener.onMessage("OK, assigned id=" + clusterId);
            ++total;
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        }
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        this.listener.onMessage("\nDone. Imported " + total + " clusters");
        return total;
    }

    private long importRecords() throws ParseException, IOException {
        long total = 0L;
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        long totalRecords = 0L;
        System.out.print("\nImporting records...");
        int lastClusterId = 0;
        long clusterRecords = 0L;
        while (this.jsonReader.lastChar() != ']') {
            ORID rid = this.importRecord();
            if (rid != null) {
                ++clusterRecords;
                if (rid.getClusterId() != lastClusterId || this.jsonReader.lastChar() == ']') {
                    System.out.print("\n- Imported records into cluster '" + this.database.getClusterNameById(lastClusterId) + "' (id=" + lastClusterId + "): " + clusterRecords + " records");
                    clusterRecords = 0L;
                    lastClusterId = rid.getClusterId();
                }
                ++totalRecords;
                continue;
            }
            lastClusterId = 0;
        }
        this.listener.onMessage("\n\nDone. Imported " + totalRecords + " records\n");
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        return total;
    }

    private ORID importRecord() throws IOException, ParseException {
        String value = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
        this.record = ORecordSerializerJSON.INSTANCE.fromString(this.database, value, this.record);
        if (this.schemaImported && this.record.getIdentity().toString().equals(this.database.getStorage().getConfiguration().schemaRecordId)) {
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            return null;
        }
        if (this.includeClusters != null) {
            if (!this.includeClusters.contains(this.database.getClusterNameById(this.record.getIdentity().getClusterId()))) {
                this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                return null;
            }
        } else if (this.excludeClusters != null && this.excludeClusters.contains(this.database.getClusterNameById(this.record.getIdentity().getClusterId()))) {
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            return null;
        }
        String rid = this.record.getIdentity().toString();
        long nextAvailablePos = this.database.getStorage().getClusterDataRange(this.record.getIdentity().getClusterId())[1] + 1L;
        if (this.record.getIdentity().getClusterPosition() < nextAvailablePos) {
            if (this.record instanceof ODocument) {
                this.record.save();
            } else {
                ((ODatabaseRecord)this.database.getUnderlying()).save(this.record);
            }
        } else {
            String clusterName = this.database.getClusterNameById(this.record.getIdentity().getClusterId());
            if (this.record.getIdentity().getClusterPosition() > nextAvailablePos) {
                int holes = (int)(this.record.getIdentity().getClusterPosition() - nextAvailablePos);
                ODocument tempRecord = new ODocument(this.database);
                for (int i = 0; i < holes; ++i) {
                    tempRecord.reset();
                    ((ODatabaseRecord)this.database.getUnderlying()).save(tempRecord, clusterName);
                    this.recordToDelete.add(tempRecord.getIdentity().toString());
                }
            }
            this.record.setIdentity(-1, -1L);
            if (this.record instanceof ODocument) {
                this.record.save(clusterName);
            } else {
                ((ODatabaseRecord)this.database.getUnderlying()).save(this.record, clusterName);
            }
        }
        if (!this.record.getIdentity().toString().equals(rid)) {
            throw new OSchemaException("Imported record '" + this.record.getIdentity() + "' has rid different from the original: " + rid);
        }
        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        return this.record.getIdentity();
    }

    public void close() {
        this.database.declareIntent(null);
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
            this.reader = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

