/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.dictionary;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.impl.ODocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODictionary<T> {
    private OIndex<OIdentifiable> index;

    public ODictionary(OIndex<OIdentifiable> iIndex) {
        this.index = iIndex;
    }

    public <RET extends T> RET get(String iKey) {
        OIdentifiable value = this.index.get(iKey);
        if (value == null) {
            return null;
        }
        return (RET)value.getRecord();
    }

    public <RET extends T> RET get(String iKey, String iFetchPlan) {
        OIdentifiable value = this.index.get(iKey);
        if (value == null) {
            return null;
        }
        if (value instanceof ORID) {
            return ((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get()).load((ORID)value, iFetchPlan);
        }
        return (RET)((ODocument)value).load(iFetchPlan);
    }

    public void put(String iKey, Object iValue) {
        this.index.put(iKey, (OIdentifiable)iValue);
    }

    public boolean containsKey(String iKey) {
        return this.index.contains(iKey);
    }

    public boolean remove(String iKey) {
        return this.index.remove(iKey);
    }

    public long size() {
        return this.index.getSize();
    }

    public Iterable<Object> keys() {
        return this.index.keys();
    }

    public OIndex<OIdentifiable> getIndex() {
        return this.index;
    }
}

