/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OIndexFullText
extends OIndexMultiValues {
    private static final String CONFIG_STOP_WORDS = "stopWords";
    private static final String CONFIG_IGNORE_CHARS = "ignoreChars";
    private static String DEF_CLUSTER_NAME = "FullTextIndex";
    private static String DEF_IGNORE_CHARS = " \r\n\t:;,.|+*/\\=!?[]()'\"";
    private static String DEF_STOP_WORDS = "the in a at as and or for his her him this that what which while up with be was is";
    private String ignoreChars = DEF_IGNORE_CHARS;
    private Set<String> stopWords = new HashSet<String>(OStringSerializerHelper.split(DEF_STOP_WORDS, ' ', new char[0]));

    public OIndexFullText() {
        super("FULLTEXT");
    }

    public OIndexFullText(String iName, ODatabaseRecord iDatabase, int[] iClusterIdsToIndex, boolean iAutomatic) {
        this(iName, OType.STRING, iDatabase, DEF_CLUSTER_NAME, iClusterIdsToIndex, iAutomatic);
    }

    public OIndexFullText(String iName, OType iKeyType, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, boolean iAutomatic) {
        this();
        this.create(iName, OType.STRING, iDatabase, iClusterIndexName, iClusterIdsToIndex, null, iAutomatic);
    }

    public void indexDocument(ODocument iDocument) {
        for (String fieldName : iDocument.fieldNames()) {
            Object fieldValue = iDocument.field(fieldName);
            this.put(fieldValue, iDocument);
        }
        this.acquireExclusiveLock();
        try {
            try {
                this.map.save();
            }
            catch (IOException e) {
                throw new OIndexException("Can't save index entry for document '" + iDocument.getIdentity() + "'");
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexFullText put(Object iKey, OIdentifiable iSingleValue) {
        if (iKey == null) {
            return this;
        }
        StringBuilder buffer = new StringBuilder();
        List<String> words = OStringSerializerHelper.split(iKey.toString(), ' ', new char[0]);
        for (String word : words) {
            Object var13_12;
            buffer.setLength(0);
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                boolean ignore = false;
                for (int k = 0; k < this.ignoreChars.length(); ++k) {
                    if (c != this.ignoreChars.charAt(k)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                buffer.append(c);
            }
            word = buffer.toString();
            if (this.stopWords.contains(word)) continue;
            this.acquireExclusiveLock();
            try {
                Set refs = (Set)this.map.get(word);
                if (refs == null) {
                    refs = new ORecordLazySet(this.configuration.getDatabase()).setRidOnly(true);
                }
                refs.add(iSingleValue);
                this.map.put(word, refs);
                var13_12 = null;
            }
            catch (Throwable throwable) {
                var13_12 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            {
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object iKey, OIdentifiable value) {
        block3: {
            boolean bl;
            this.acquireExclusiveLock();
            try {
                Object recs = this.get(iKey);
                if (recs == null || recs.isEmpty() || !recs.remove(value)) break block3;
                this.map.put(iKey, recs);
                bl = true;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return bl;
        }
        Object var6_6 = null;
        this.releaseExclusiveLock();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument updateConfiguration() {
        super.updateConfiguration();
        this.configuration.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.configuration.field(CONFIG_IGNORE_CHARS, this.ignoreChars);
            this.configuration.field(CONFIG_STOP_WORDS, this.stopWords);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
            throw throwable;
        }
        this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
        return this.configuration;
    }
}

