/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.concur.resource.OSharedResourceExternal;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.annotation.ODocumentInstance;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCallback;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerLiteral;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeDatabaseLazySave;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexMVRBTreeAbstract<T>
extends OSharedResourceExternal
implements OIndexInternal<T>,
ODatabaseListener {
    protected static final String CONFIG_MAP_RID = "mapRid";
    protected static final String CONFIG_CLUSTERS = "clusters";
    protected String name;
    protected String type;
    protected OMVRBTreeDatabaseLazySave<Object, T> map;
    protected Set<String> clustersToIndex = new LinkedHashSet<String>();
    protected OIndexCallback callback;
    protected boolean automatic;
    protected OType keyType;
    @ODocumentInstance
    protected ODocument configuration;
    private OMemoryWatchDog.Listener watchDog;

    public OIndexMVRBTreeAbstract(String iType) {
        this.type = iType;
        this.watchDog = new OMemoryWatchDog.Listener(){

            public void memoryUsageLow(OMemoryWatchDog.Listener.TYPE iType, long usedMemory, long maxMemory) {
                if (iType == OMemoryWatchDog.Listener.TYPE.JVM) {
                    OIndexMVRBTreeAbstract.this.map.setOptimization(1);
                }
            }

            public void memoryUsageCritical(OMemoryWatchDog.Listener.TYPE iType, long usedMemory, long maxMemory) {
                if (iType == OMemoryWatchDog.Listener.TYPE.JVM) {
                    OIndexMVRBTreeAbstract.this.map.setOptimization(2);
                }
            }
        };
    }

    @Override
    public void flush() {
        this.lazySave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexInternal<T> create(String iName, OType iKeyType, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener, boolean iAutomatic, OStreamSerializer iValueSerializer) {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            this.name = iName;
            this.configuration = new ODocument(iDatabase);
            this.automatic = iAutomatic;
            this.keyType = iKeyType;
            if (iClusterIdsToIndex != null) {
                for (int id : iClusterIdsToIndex) {
                    this.clustersToIndex.add(iDatabase.getClusterNameById(id));
                }
            }
            this.map = new OMVRBTreeDatabaseLazySave(iDatabase, iClusterIndexName, OStreamSerializerLiteral.INSTANCE, iValueSerializer);
            this.installHooks(iDatabase);
            this.rebuild(iProgressListener);
            this.updateConfiguration();
            oIndexMVRBTreeAbstract = this;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexInternal<T> loadFromConfiguration(ODocument iConfig) {
        ORID rid;
        block5: {
            OIndexInternal<T> oIndexInternal;
            this.acquireExclusiveLock();
            try {
                rid = (ORID)iConfig.field(CONFIG_MAP_RID, ORID.class);
                if (rid != null) break block5;
                oIndexInternal = null;
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oIndexInternal;
        }
        this.configuration = iConfig;
        this.name = (String)this.configuration.field("name");
        this.automatic = (Boolean)(this.configuration.field("automatic") != null ? this.configuration.field("automatic") : Boolean.valueOf(true));
        String configuredKeyType = (String)this.configuration.field("keyType");
        if (configuredKeyType != null) {
            this.keyType = OType.valueOf(configuredKeyType.toUpperCase());
        }
        this.clustersToIndex.clear();
        Collection clusters = (Collection)this.configuration.field(CONFIG_CLUSTERS);
        if (clusters != null) {
            this.clustersToIndex.addAll(clusters);
        }
        this.map = new OMVRBTreeDatabaseLazySave(this.getDatabase(), rid);
        this.map.load();
        this.installHooks(iConfig.getDatabase());
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract = this;
        Object var7_6 = null;
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object iKey) {
        boolean bl;
        this.acquireExclusiveLock();
        try {
            bl = this.map.containsKey(iKey);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return bl;
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, Object iRangeTo) {
        return this.getValuesBetween(iRangeFrom, iRangeTo, true);
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo) {
        return this.getEntriesBetween(iRangeFrom, iRangeTo, true);
    }

    @Override
    public ORID getIdentity() {
        return this.map.getRecord().getIdentity();
    }

    @Override
    public long rebuild() {
        return this.rebuild(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long rebuild(OProgressListener iProgressListener) {
        long documentIndexed;
        block13: {
            this.clear();
            documentIndexed = 0L;
            boolean intentInstalled = this.getDatabase().declareIntent(new OIntentMassiveInsert());
            this.acquireExclusiveLock();
            try {
                try {
                    int documentNum = 0;
                    long documentTotal = 0L;
                    for (String cluster : this.clustersToIndex) {
                        documentTotal += this.getDatabase().countClusterElements(cluster);
                    }
                    if (iProgressListener != null) {
                        iProgressListener.onBegin((Object)this, documentTotal);
                    }
                    for (String clusterName : this.clustersToIndex) {
                        for (ORecordInternal record : this.getDatabase().browseCluster(clusterName)) {
                            ODocument doc;
                            Object fieldValue;
                            if (record instanceof ODocument && (fieldValue = this.callback.getDocumentValueToIndex(doc = (ODocument)record)) != null) {
                                this.put(fieldValue, doc);
                                ++documentIndexed;
                            }
                            ++documentNum;
                            if (iProgressListener == null) continue;
                            iProgressListener.onProgress((Object)this, (long)documentNum, (float)documentNum * 100.0f / (float)documentTotal);
                        }
                    }
                    this.lazySave();
                    if (iProgressListener != null) {
                        iProgressListener.onCompletition((Object)this, true);
                    }
                }
                catch (Exception e) {
                    if (iProgressListener != null) {
                        iProgressListener.onCompletition((Object)this, false);
                    }
                    this.clear();
                    throw new OIndexException("Error on rebuilding the index for clusters: " + this.clustersToIndex, e);
                }
                Object var15_13 = null;
                if (!intentInstalled) break block13;
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                if (intentInstalled) {
                    this.getDatabase().declareIntent(null);
                }
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.getDatabase().declareIntent(null);
        }
        this.releaseExclusiveLock();
        return documentIndexed;
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iValue) {
        return this.remove(iKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key) {
        boolean bl;
        this.acquireExclusiveLock();
        try {
            bl = this.map.remove(key) != null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<T> clear() {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            this.map.clear();
            oIndexMVRBTreeAbstract = this;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexInternal<T> delete() {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            this.map.delete();
            oIndexMVRBTreeAbstract = this;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexInternal<T> lazySave() {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            this.map.lazySave();
            oIndexMVRBTreeAbstract = this;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    public ORecordBytes getRecord() {
        return this.map.getRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Map.Entry<Object, T>> iterator() {
        Iterator<Map.Entry<Object, T>> iterator;
        this.acquireExclusiveLock();
        try {
            iterator = this.map.entrySet().iterator();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Object> keys() {
        Set set;
        this.acquireExclusiveLock();
        try {
            set = this.map.keySet();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.map.size();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.name + " (" + (this.type != null ? this.type : "?") + ")" + (this.map != null ? " " + this.map : "");
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return this;
    }

    public OIndexCallback getCallback() {
        return this.callback;
    }

    @Override
    public void setCallback(OIndexCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getClusters() {
        Set<String> set;
        this.acquireSharedLock();
        try {
            set = Collections.unmodifiableSet(this.clustersToIndex);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexMVRBTreeAbstract<T> addCluster(String iClusterName) {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            this.clustersToIndex.add(iClusterName);
            oIndexMVRBTreeAbstract = this;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return oIndexMVRBTreeAbstract;
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object iKey) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() {
        this.acquireExclusiveLock();
        try {
            this.map.unload();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument updateConfiguration() {
        this.acquireExclusiveLock();
        try {
            this.configuration.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                this.configuration.field("type", this.type);
                this.configuration.field("name", this.name);
                this.configuration.field("automatic", this.automatic);
                if (this.keyType != null) {
                    this.configuration.field("keyType", this.keyType.toString());
                }
                this.configuration.field(CONFIG_CLUSTERS, this.clustersToIndex, OType.EMBEDDEDSET);
                this.configuration.field(CONFIG_MAP_RID, this.map.getRecord().getIdentity());
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
                throw throwable;
            }
            this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(ODocument iDocument) {
        if (iDocument == null) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            this.map.setRunningTransaction(true);
            Boolean clearAll = (Boolean)iDocument.field("clear");
            if (clearAll != null && clearAll.booleanValue()) {
                this.clear();
            }
            Collection entries = (Collection)iDocument.field("entries");
            for (ODocument entry : entries) {
                Object key = ORecordSerializerStringAbstract.getTypeValue(OStringSerializerHelper.decode((String)entry.field("k")));
                List operations = (List)entry.field("ops");
                if (operations == null) continue;
                for (ODocument op : operations) {
                    int operation = (Integer)op.rawField("o");
                    OIdentifiable value = (OIdentifiable)op.field("v");
                    if (operation == OTransactionIndexChanges.OPERATION.PUT.ordinal()) {
                        this.put(key, value);
                        continue;
                    }
                    if (operation != OTransactionIndexChanges.OPERATION.REMOVE.ordinal()) continue;
                    if (key.equals("*")) {
                        this.remove(value);
                        continue;
                    }
                    if (value == null) {
                        this.remove(key);
                        continue;
                    }
                    this.remove(key, value);
                }
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.releaseExclusiveLock();
            this.map.setRunningTransaction(false);
            throw throwable;
        }
        this.releaseExclusiveLock();
        this.map.setRunningTransaction(false);
    }

    @Override
    public ODocument getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isAutomatic() {
        return this.automatic;
    }

    protected void installHooks(ODatabaseRecord iDatabase) {
        OProfiler.getInstance().registerHookValue("index." + this.name + ".items", new OProfiler.OProfilerHookValue(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getValue() {
                String string;
                OIndexMVRBTreeAbstract.this.acquireSharedLock();
                try {
                    string = OIndexMVRBTreeAbstract.this.map != null ? Integer.valueOf(OIndexMVRBTreeAbstract.this.map.size()) : "-";
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OIndexMVRBTreeAbstract.this.releaseSharedLock();
                    throw throwable;
                }
                OIndexMVRBTreeAbstract.this.releaseSharedLock();
                return string;
            }
        });
        OProfiler.getInstance().registerHookValue("index." + this.name + ".entryPointSize", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OIndexMVRBTreeAbstract.this.map != null ? Integer.valueOf(OIndexMVRBTreeAbstract.this.map.getEntryPointSize()) : "-";
            }
        });
        OProfiler.getInstance().registerHookValue("index." + this.name + ".maxUpdateBeforeSave", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OIndexMVRBTreeAbstract.this.map != null ? Integer.valueOf(OIndexMVRBTreeAbstract.this.map.getMaxUpdatesBeforeSave()) : "-";
            }
        });
        OProfiler.getInstance().registerHookValue("index." + this.name + ".optimizationThreshold", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OIndexMVRBTreeAbstract.this.map != null ? Integer.valueOf(OIndexMVRBTreeAbstract.this.map.getOptimizeThreshold()) : "-";
            }
        });
        Orient.instance().getMemoryWatchDog().addListener(this.watchDog);
        iDatabase.registerListener(this);
    }

    protected void uninstallHooks(ODatabaseRecord iDatabase) {
        OProfiler.getInstance().unregisterHookValue("index." + this.name + ".items");
        OProfiler.getInstance().unregisterHookValue("index." + this.name + ".entryPointSize");
        OProfiler.getInstance().unregisterHookValue("index." + this.name + ".maxUpdateBeforeSave");
        OProfiler.getInstance().unregisterHookValue("index." + this.name + ".optimizationThreshold");
        Orient.instance().getMemoryWatchDog().removeListener(this.watchDog);
        iDatabase.unregisterListener(this);
    }

    @Override
    public void onCreate(ODatabase iDatabase) {
    }

    @Override
    public void onDelete(ODatabase iDatabase) {
    }

    @Override
    public void onOpen(ODatabase iDatabase) {
    }

    @Override
    public void onBeforeTxBegin(ODatabase iDatabase) {
    }

    @Override
    public void onBeforeTxRollback(ODatabase iDatabase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterTxRollback(ODatabase iDatabase) {
        this.acquireExclusiveLock();
        try {
            this.map.unload();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBeforeTxCommit(ODatabase iDatabase) {
        this.acquireExclusiveLock();
        try {
            this.map.commitChanges();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterTxCommit(ODatabase iDatabase) {
        this.acquireExclusiveLock();
        try {
            this.map.onAfterTxCommit();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(ODatabase iDatabase) {
        this.acquireExclusiveLock();
        try {
            this.map.commitChanges();
            Orient.instance().getMemoryWatchDog().removeListener(this.watchDog);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimize(boolean iHardMode) {
        if (this.map == null) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            OLogManager.instance().debug((Object)this, "Forcing " + (iHardMode ? "hard" : "soft") + " optimization of Index %s (%d items). Found %d entries in memory...", new Object[]{this.name, this.map.size(), this.map.getNumberOfNodesInCache()});
            this.map.setOptimization(iHardMode ? 2 : 1);
            int freed = this.map.optimize(iHardMode);
            OLogManager.instance().debug((Object)this, "Completed! Freed %d entries and now %d entries reside in memory", new Object[]{freed, this.map.getNumberOfNodesInCache()});
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    protected void checkForKeyType(Object iKey) {
        if (this.keyType == null) {
            this.keyType = OType.getTypeByClass(iKey.getClass());
            if (this.keyType != null) {
                this.updateConfiguration();
            }
        }
    }

    protected ODatabaseRecord getDatabase() {
        return (ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public OType getKeyType() {
        return this.keyType;
    }

    public OSharedResourceAbstract getLock() {
        return this;
    }
}

