/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCallback;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexTxAwareMultiValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareOneValue;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexManagerAbstract
extends ODocumentWrapperNoClass
implements OIndexManager,
OCloseable {
    public static final String CONFIG_INDEXES = "indexes";
    public static final String DICTIONARY_NAME = "dictionary";
    protected Map<String, OIndexInternal<?>> indexes = new HashMap();
    protected String defaultClusterName = "index";

    public OIndexManagerAbstract(ODatabaseRecord iDatabase) {
        super(new ODocument(iDatabase));
    }

    protected abstract OIndex<?> getIndexInstance(OIndex<?> var1);

    @Override
    public synchronized OIndexManagerAbstract load() {
        if (this.getDatabase().getStorage().getConfiguration().indexMgrRecordId == null) {
            this.create();
        }
        this.indexes.clear();
        ((ORecordId)this.document.getIdentity()).fromString(this.getDatabase().getStorage().getConfiguration().indexMgrRecordId);
        super.reload("*:-1 index:0");
        return this;
    }

    @Override
    public synchronized <RET extends ODocumentWrapper> RET reload() {
        this.document.setDatabase((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get());
        return super.reload();
    }

    @Override
    public synchronized <RET extends ODocumentWrapper> RET save() {
        this.document.setDatabase((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get());
        return super.save();
    }

    @Override
    public synchronized void create() {
        this.save("internal");
        this.getDatabase().getStorage().getConfiguration().indexMgrRecordId = this.document.getIdentity().toString();
        this.getDatabase().getStorage().getConfiguration().update();
        this.createIndex(DICTIONARY_NAME, OProperty.INDEX_TYPE.DICTIONARY.toString(), OType.STRING, null, null, null, false);
    }

    @Override
    public synchronized void flush() {
        for (OIndexInternal<?> idx : this.indexes.values()) {
            idx.flush();
        }
    }

    public synchronized OIndex<?> createIndex(String iName, String iType, OType iKeyType, int[] iClusterIdsToIndex, OIndexCallback iCallback, OProgressListener iProgressListener) {
        return this.createIndex(iName, iType, iKeyType, iClusterIdsToIndex, iCallback, iProgressListener, false);
    }

    @Override
    public synchronized Collection<? extends OIndex<?>> getIndexes() {
        return Collections.unmodifiableCollection(this.indexes.values());
    }

    @Override
    public synchronized OIndex<?> getIndex(String iName) {
        OIndex index = this.indexes.get(iName.toLowerCase());
        if (index == null) {
            return null;
        }
        if (index instanceof OIndexMultiValues) {
            return new OIndexTxAwareMultiValue(this.getDatabase(), this.getIndexInstance(index));
        }
        return new OIndexTxAwareOneValue(this.getDatabase(), this.getIndexInstance(index));
    }

    public synchronized boolean existsIndex(String iName) {
        return this.indexes.containsKey(iName.toLowerCase());
    }

    @Override
    public synchronized String getDefaultClusterName() {
        return this.defaultClusterName;
    }

    @Override
    public synchronized void setDefaultClusterName(String defaultClusterName) {
        this.defaultClusterName = defaultClusterName;
    }

    @Override
    public synchronized ODictionary<ORecordInternal<?>> getDictionary() {
        OIndex<OIdentifiable> idx = this.getIndex(DICTIONARY_NAME);
        if (idx == null) {
            idx = this.createIndex(DICTIONARY_NAME, OProperty.INDEX_TYPE.DICTIONARY.toString(), OType.STRING, null, null, null, false);
        }
        return new ODictionary(idx);
    }

    @Override
    public ODocument getConfiguration() {
        return this.getDocument();
    }

    protected ODatabaseRecord getDatabase() {
        this.document.setDatabase((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get());
        return this.document.getDatabase();
    }

    public void close() {
        this.flush();
        this.indexes.clear();
    }

    public synchronized OIndexManager setDirty() {
        this.document.setDirty();
        return this;
    }

    @Override
    public synchronized OIndex<?> getIndex(ORID iRID) {
        for (OIndexInternal<?> idx : this.indexes.values()) {
            if (!idx.getIdentity().equals(iRID)) continue;
            return this.getIndexInstance(idx);
        }
        return null;
    }
}

