/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.ONavigableMap;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexMVRBTreeAbstract;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexOneValue
extends OIndexMVRBTreeAbstract<OIdentifiable> {
    public OIndexOneValue(String iType) {
        super(iType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIdentifiable get(Object iKey) {
        OIdentifiable oIdentifiable;
        this.acquireExclusiveLock();
        try {
            oIdentifiable = (OIdentifiable)this.map.get(iKey);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIdentifiable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(OIdentifiable iRecord) {
        int n;
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                if (!((OIdentifiable)entries.getValue()).equals(iRecord)) continue;
                this.remove(entries.getKey(), iRecord);
                ++tot;
            }
            n = tot;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(OIdentifiable iRecord) {
        int n;
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                if (!((OIdentifiable)entries.getValue()).equals(iRecord)) continue;
                ++tot;
            }
            n = tot;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive) {
        Set<OIdentifiable> set;
        this.acquireExclusiveLock();
        try {
            set = this.getLazySet((ONavigableMap<Object, OIdentifiable>)this.map.tailMap(fromKey, isInclusive));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive) {
        Set<OIdentifiable> set;
        this.acquireExclusiveLock();
        try {
            set = this.getLazySet((ONavigableMap<Object, OIdentifiable>)this.map.headMap(toKey, isInclusive));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive) {
        HashSet<ODocument> hashSet;
        this.acquireExclusiveLock();
        try {
            HashSet<ODocument> result = new HashSet<ODocument>();
            ONavigableMap subSet = this.map.tailMap(fromKey, isInclusive);
            if (subSet != null) {
                for (Map.Entry v : subSet.entrySet()) {
                    ODocument document = new ODocument();
                    document.field("key", v.getKey());
                    document.field("rid", ((OIdentifiable)v.getValue()).getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
            }
            hashSet = result;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive) {
        HashSet<ODocument> hashSet;
        this.acquireExclusiveLock();
        try {
            HashSet<ODocument> result = new HashSet<ODocument>();
            ONavigableMap subSet = this.map.headMap(toKey, isInclusive);
            if (subSet != null) {
                for (Map.Entry v : subSet.entrySet()) {
                    ODocument document = new ODocument();
                    document.field("key", v.getKey());
                    document.field("rid", ((OIdentifiable)v.getValue()).getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
            }
            hashSet = result;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OIdentifiable> getValuesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        Set<OIdentifiable> set;
        if (iRangeFrom.getClass() != iRangeTo.getClass()) {
            throw new IllegalArgumentException("Range from-to parameters are of different types");
        }
        this.acquireExclusiveLock();
        try {
            Set<OIdentifiable> result;
            ONavigableMap subSet = this.map.subMap(iRangeFrom, iInclusive, iRangeTo, iInclusive);
            set = result = this.getLazySet((ONavigableMap<Object, OIdentifiable>)subSet);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        HashSet<ODocument> hashSet;
        if (iRangeFrom.getClass() != iRangeTo.getClass()) {
            throw new IllegalArgumentException("Range from-to parameters are of different types");
        }
        this.acquireExclusiveLock();
        try {
            HashSet<ODocument> result = new HashSet<ODocument>();
            ONavigableMap subSet = this.map.subMap(iRangeFrom, iInclusive, iRangeTo, iInclusive);
            if (subSet != null) {
                for (Map.Entry v : subSet.entrySet()) {
                    ODocument document = new ODocument();
                    document.field("key", v.getKey());
                    document.field("rid", ((OIdentifiable)v.getValue()).getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
            }
            hashSet = result;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return hashSet;
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object iKey) {
        OIdentifiable indexedRID = this.get(iKey);
        if (indexedRID != null && !indexedRID.getIdentity().equals(iRecord.getIdentity())) {
            OLogManager.instance().exception("Found duplicated key '%s' previously assigned to the record %s", null, OIndexException.class, new Object[]{iKey, indexedRID});
        }
    }

    public OIndexOneValue create(String iName, OType iKeyType, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener, boolean iAutomatic) {
        return (OIndexOneValue)super.create(iName, iKeyType, iDatabase, iClusterIndexName, iClusterIdsToIndex, iProgressListener, iAutomatic, OStreamSerializerRID.INSTANCE);
    }

    private Set<OIdentifiable> getLazySet(ONavigableMap<Object, OIdentifiable> iSubSet) {
        if (iSubSet == null) {
            return ORecordLazySet.EMPTY_SET;
        }
        ORecordLazySet result = new ORecordLazySet(this.configuration.getDatabase());
        result.addAll(iSubSet.values());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys);
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        this.acquireExclusiveLock();
        try {
            for (Comparable key : sortedKeys) {
                OIdentifiable val = (OIdentifiable)this.map.get(key);
                if (val == null) continue;
                result.add(val);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys);
        HashSet<ODocument> result = new HashSet<ODocument>();
        this.acquireExclusiveLock();
        try {
            for (Comparable key : sortedKeys) {
                OIdentifiable val = (OIdentifiable)this.map.get(key);
                if (val == null) continue;
                ODocument document = new ODocument();
                document.field("key", key);
                document.field("rid", val.getIdentity());
                document.unsetDirty();
                result.add(document);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return result;
    }
}

