/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstractDelegate;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexTxAware<T>
extends OIndexAbstractDelegate<T> {
    protected ODatabaseRecord database;

    public OIndexTxAware(ODatabaseRecord iDatabase, OIndex<T> iDelegate) {
        super(iDelegate);
        this.database = iDatabase;
    }

    @Override
    public long getSize() {
        long tot = this.delegate.getSize();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges != null) {
            if (indexChanges.cleared) {
                tot = 0L;
            }
            for (Map.Entry<Object, OTransactionIndexChangesPerKey> entry : indexChanges.changesPerKey.entrySet()) {
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry e : entry.getValue().entries) {
                    if (e.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                        if (e.value != null) continue;
                        --tot;
                        continue;
                    }
                    if (e.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                }
            }
        }
        return tot;
    }

    @Override
    public OIndexTxAware<T> put(Object iKey, OIdentifiable iValue) {
        ORID rid = iValue.getIdentity();
        if (!rid.isValid()) {
            ((ORecord)iValue).save();
        }
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.PUT, iKey, rid);
        return this;
    }

    @Override
    public boolean remove(Object iKey) {
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, iKey, null);
        return true;
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, iKey, iRID);
        return true;
    }

    @Override
    public int remove(OIdentifiable iRID) {
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, null, iRID);
        return 1;
    }

    @Override
    public OIndexTxAware<T> clear() {
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.CLEAR, null, null);
        return this;
    }

    @Override
    public void unload() {
        this.database.getTransaction().clearIndexEntries();
        super.unload();
    }
}

