/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexTxAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexTxAwareMultiValue
extends OIndexTxAware<Collection<OIdentifiable>> {
    public OIndexTxAwareMultiValue(ODatabaseRecord iDatabase, OIndex<Collection<OIdentifiable>> iDelegate) {
        super(iDatabase, iDelegate);
    }

    @Override
    public Collection<OIdentifiable> get(Object iKey) {
        OTransactionIndexChangesPerKey value;
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        ArrayList<OIdentifiable> result = indexChanges == null || !indexChanges.cleared ? new ArrayList((Collection)super.get(iKey)) : new ArrayList<OIdentifiable>();
        if (indexChanges != null && indexChanges.containsChangesPerKey(iKey) && (value = indexChanges.getChangesPerKey(iKey)) != null) {
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                    if (entry.value == null) {
                        result.clear();
                        break;
                    }
                    result.remove(entry.value);
                    continue;
                }
                if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                result.add(entry.value);
            }
        }
        return result;
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        ArrayList keys = new ArrayList(iKeys);
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        HashSet keysToRemove = new HashSet();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            result.addAll(super.getValues(keys));
            return result;
        }
        for (Object key : keys) {
            OTransactionIndexChangesPerKey value;
            ArrayList<OIdentifiable> keyResult;
            if (!indexChanges.cleared) {
                if (!indexChanges.containsChangesPerKey(key)) continue;
                keyResult = new ArrayList((Collection)super.get(key));
            } else {
                keyResult = new ArrayList<OIdentifiable>();
            }
            keysToRemove.add(key);
            if (indexChanges.containsChangesPerKey(key) && (value = indexChanges.getChangesPerKey(key)) != null) {
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                    if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                        if (entry.value == null) {
                            keyResult.clear();
                            break;
                        }
                        keyResult.remove(entry.value);
                        continue;
                    }
                    if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                    keyResult.add(entry.value);
                }
            }
            result.addAll(keyResult);
        }
        keys.removeAll(keysToRemove);
        if (!keys.isEmpty()) {
            result.addAll(super.getValues(keys));
        }
        return result;
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        ArrayList keys = new ArrayList(iKeys);
        HashSet<ODocument> result = new HashSet<ODocument>();
        HashSet keysToRemove = new HashSet();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            result.addAll(super.getEntries(keys));
            return result;
        }
        for (Object key : keys) {
            OTransactionIndexChangesPerKey value;
            ArrayList<OIdentifiable> keyResult;
            if (!indexChanges.cleared) {
                if (!indexChanges.containsChangesPerKey(key)) continue;
                keyResult = new ArrayList((Collection)super.get(key));
            } else {
                keyResult = new ArrayList<OIdentifiable>();
            }
            keysToRemove.add(key);
            if (indexChanges.containsChangesPerKey(key) && (value = indexChanges.getChangesPerKey(key)) != null) {
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                    if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                        if (entry.value == null) {
                            keyResult.clear();
                            break;
                        }
                        keyResult.remove(entry.value);
                        continue;
                    }
                    if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                    keyResult.add(entry.value);
                }
            }
            for (OIdentifiable id : keyResult) {
                ODocument document = new ODocument();
                document.field("key", key);
                document.field("rid", id.getIdentity());
                document.unsetDirty();
                result.add(document);
            }
        }
        keys.removeAll(keysToRemove);
        if (!keys.isEmpty()) {
            result.addAll(super.getEntries(keys));
        }
        return result;
    }
}

