/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexTxAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexTxAwareOneValue
extends OIndexTxAware<OIdentifiable> {
    public OIndexTxAwareOneValue(ODatabaseRecord iDatabase, OIndex<OIdentifiable> iDelegate) {
        super(iDatabase, iDelegate);
    }

    @Override
    public OIdentifiable get(Object iKey) {
        OTransactionIndexChangesPerKey value;
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        OIdentifiable result = indexChanges == null || !indexChanges.cleared ? (OIdentifiable)super.get(iKey) : null;
        if (indexChanges != null && indexChanges.containsChangesPerKey(iKey) && (value = indexChanges.getChangesPerKey(iKey)) != null) {
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                    if (entry.value != null) continue;
                    result = null;
                    break;
                }
                if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                result = entry.value;
            }
        }
        return result;
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        ArrayList keys = new ArrayList(iKeys);
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            result.addAll(super.getValues(keys));
            return result;
        }
        HashSet keysToRemove = new HashSet();
        for (Object key : keys) {
            OTransactionIndexChangesPerKey value;
            if (indexChanges.cleared) {
                keysToRemove.add(key);
            }
            OIdentifiable keyResult = null;
            if (indexChanges.containsChangesPerKey(key) && (value = indexChanges.getChangesPerKey(key)) != null) {
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                    if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                        if (entry.value != null) continue;
                        keysToRemove.add(key);
                        keyResult = null;
                        break;
                    }
                    if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                    keyResult = entry.value;
                    keysToRemove.add(key);
                }
            }
            if (keyResult == null) continue;
            result.add(keyResult);
        }
        keys.removeAll(keysToRemove);
        if (!keys.isEmpty()) {
            result.addAll(super.getValues(keys));
        }
        return result;
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        ArrayList keys = new ArrayList(iKeys);
        HashSet<ODocument> result = new HashSet<ODocument>();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            result.addAll(super.getEntries(keys));
            return result;
        }
        HashSet keysToRemove = new HashSet();
        for (Object key : keys) {
            OTransactionIndexChangesPerKey value;
            if (indexChanges.cleared) {
                keysToRemove.add(key);
            }
            OIdentifiable keyResult = null;
            if (indexChanges.containsChangesPerKey(key) && (value = indexChanges.getChangesPerKey(key)) != null) {
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                    if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                        if (entry.value != null) continue;
                        keysToRemove.add(key);
                        keyResult = null;
                        break;
                    }
                    if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                    keyResult = entry.value;
                    keysToRemove.add(key);
                }
            }
            if (keyResult == null) continue;
            ODocument document = new ODocument();
            document.field("key", key);
            document.field("rid", keyResult.getIdentity());
            document.unsetDirty();
            result.add(document);
        }
        keys.removeAll(keysToRemove);
        if (!keys.isEmpty()) {
            result.addAll(super.getEntries(keys));
        }
        return result;
    }
}

