/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCallback;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPropertyIndex
implements OIndexCallback {
    protected String indexName;
    protected String[] fields;
    protected static final char FIELD_SEPARATOR = '+';

    public OPropertyIndex(ODatabaseRecord iDatabase, OClass iClass, String[] iFields, String iType, OType iKeyType, OProgressListener iProgressListener) {
        this.fields = iFields;
        this.indexName = this.getIndexName(iClass, iFields);
        iDatabase.getMetadata().getIndexManager().createIndex(this.indexName, iType, iKeyType, iClass.getClusterIds(), this, iProgressListener, true);
    }

    public OPropertyIndex(ODatabaseRecord iDatabase, OClass iClass, String[] iFields, String iType, OType iKeyType) {
        this.fields = iFields;
        this.indexName = this.getIndexName(iClass, iFields);
        iDatabase.getMetadata().getIndexManager().createIndex(this.indexName, iType, iKeyType, iClass.getClusterIds(), this, null, true);
    }

    public OPropertyIndex(ODatabaseRecord iDatabase, OClass iClass, String[] iFields) {
        this.fields = iFields;
        this.indexName = this.getIndexName(iClass, iFields);
        OIndex<?> idx = iDatabase.getMetadata().getIndexManager().getIndex(this.indexName);
        if (idx != null) {
            idx.setCallback(this);
        }
    }

    public void checkEntry(ODocument iRecord) {
        Object key = this.generateKey(iRecord);
        OIndexInternal<?> idx = this.getUnderlying().getInternal();
        try {
            idx.checkEntry(iRecord, key);
        }
        catch (OIndexException e) {
            OLogManager.instance().exception("Invalid constraints on index '%s' for key '%s' in record %s for the fields '%s'", (Exception)((Object)e), OIndexException.class, new Object[]{this.indexName, key, iRecord.getIdentity(), Arrays.toString(this.fields)});
        }
    }

    public void setCallback(OIndexCallback iCallback) {
    }

    public OIndex<?> getUnderlying() {
        return ((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get()).getMetadata().getIndexManager().getIndex(this.indexName);
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        return this.generateKey(iDocument);
    }

    private Object generateKey(ODocument iRecord) {
        if (this.fields.length == 1) {
            return iRecord.field(this.fields[0]);
        }
        StringBuilder buffer = new StringBuilder();
        for (String f : this.fields) {
            if (buffer.length() > 0) {
                buffer.append('+');
            }
            if (f == null) {
                buffer.append('-');
                continue;
            }
            buffer.append(iRecord.field(f));
        }
        return buffer.toString();
    }

    public String toString() {
        return this.indexName;
    }

    private String getIndexName(OClass iClass, String[] iFields) {
        StringBuilder indexName = new StringBuilder();
        indexName.append(iClass.getName());
        indexName.append('.');
        boolean first = true;
        for (String f : iFields) {
            if (first) {
                first = false;
            } else {
                indexName.append('_');
            }
            indexName.append(f);
        }
        return indexName.toString();
    }
}

