/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.iterator.ORecordIterator;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordIteratorClass<REC extends ORecordInternal<?>>
extends ORecordIterator<REC> {
    protected final int[] clusterIds;
    protected int currentClusterIdx;
    protected boolean polymorphic;

    public ORecordIteratorClass(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase, String iClassName, boolean iPolymorphic) {
        super(iDatabase, iLowLevelDatabase);
        this.polymorphic = iPolymorphic;
        this.clusterIds = this.polymorphic ? this.database.getMetadata().getSchema().getClass(iClassName).getPolymorphicClusterIds() : this.database.getMetadata().getSchema().getClass(iClassName).getClusterIds();
        this.currentClusterIdx = 0;
        this.updateClusterRange();
        this.current.clusterPosition = this.firstClusterPosition - 1L;
        this.totalAvailableRecords = this.database.countClusterElements(this.clusterIds);
        this.txEntries = iDatabase.getTransaction().getRecordEntriesByClass(iClassName);
        if (this.txEntries != null) {
            for (OTransactionRecordEntry entry : this.txEntries) {
                if (entry.getRecord().getIdentity().isTemporary()) {
                    ++this.totalAvailableRecords;
                    continue;
                }
                if (entry.status != 2) continue;
                --this.totalAvailableRecords;
            }
        }
    }

    @Override
    public boolean hasPrevious() {
        this.checkDirection(false);
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.liveUpdated) {
            return this.current.clusterPosition > this.database.getStorage().getClusterDataRange(this.current.clusterId)[0];
        }
        while (this.currentClusterIdx > -1) {
            if (this.current.clusterPosition > this.firstClusterPosition) {
                return true;
            }
            --this.currentClusterIdx;
            this.updateClusterRange();
            this.current.clusterPosition = this.lastClusterPosition + 1L;
        }
        return this.txEntries != null && this.txEntries.size() - (this.currentTxEntryPosition + 1) > 0;
    }

    @Override
    public boolean hasNext() {
        this.checkDirection(true);
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.liveUpdated) {
            this.lastClusterPosition = this.database.getStorage().getClusterDataRange(this.current.clusterId)[1];
        }
        while (this.currentClusterIdx < this.clusterIds.length) {
            long recordsToBrowse;
            long l = recordsToBrowse = this.current.clusterPosition > -2L && this.lastClusterPosition > -1L ? this.lastClusterPosition - this.current.clusterPosition : 0L;
            if (recordsToBrowse > 0L) {
                return true;
            }
            ++this.currentClusterIdx;
            if (this.currentClusterIdx >= this.clusterIds.length) break;
            this.updateClusterRange();
            this.current.clusterPosition = this.firstClusterPosition - 1L;
        }
        return this.txEntries != null && this.txEntries.size() - (this.currentTxEntryPosition + 1) > 0;
    }

    @Override
    public REC previous() {
        this.checkDirection(false);
        ORecordInternal<?> record = this.getRecord();
        while (this.currentClusterIdx > -1) {
            while (this.hasPrevious()) {
                if ((record = this.readCurrentRecord(record, -1)) == null) continue;
                return (REC)record;
            }
            --this.currentClusterIdx;
            this.updateClusterRange();
            this.current.clusterPosition = this.lastClusterPosition + 1L;
        }
        throw new NoSuchElementException();
    }

    @Override
    public REC next() {
        this.checkDirection(true);
        ORecordInternal<Object> record = this.getRecord();
        while (this.currentClusterIdx < this.clusterIds.length) {
            while (this.hasNext()) {
                record = this.getTransactionEntry();
                if (record != null) {
                    return (REC)record;
                }
                record = this.readCurrentRecord(null, 1);
                if (record == null) continue;
                return (REC)record;
            }
            ++this.currentClusterIdx;
            if (this.currentClusterIdx >= this.clusterIds.length) break;
            this.updateClusterRange();
            this.current.clusterPosition = this.firstClusterPosition - 1L;
        }
        if ((record = this.getTransactionEntry()) != null) {
            return (REC)record;
        }
        throw new NoSuchElementException();
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public ORecordInternal<?> current() {
        return this.readCurrentRecord(this.getRecord(), 0);
    }

    @Override
    public ORecordIterator<REC> begin() {
        this.currentClusterIdx = 0;
        this.current.clusterPosition = -1L;
        return this;
    }

    @Override
    public ORecordIterator<REC> last() {
        this.currentClusterIdx = this.clusterIds.length - 1;
        this.current.clusterPosition = this.liveUpdated ? this.database.countClusterElements(this.clusterIds[this.currentClusterIdx]) : this.lastClusterPosition + 1L;
        return this;
    }

    @Override
    public ORecordIterator<REC> setLiveUpdated(boolean iLiveUpdated) {
        super.setLiveUpdated(iLiveUpdated);
        long l = this.lastClusterPosition = iLiveUpdated ? -1L : this.database.countClusterElements(this.current.clusterId);
        if (iLiveUpdated) {
            this.firstClusterPosition = -1L;
            this.lastClusterPosition = -1L;
        } else {
            this.updateClusterRange();
        }
        return this;
    }

    private ORecordInternal<?> readCurrentRecord(ORecordInternal<?> iRecord, int iMovement) {
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return null;
        }
        this.current.clusterPosition += (long)iMovement;
        if (iRecord != null) {
            iRecord.setIdentity(this.current);
            iRecord = this.lowLevelDatabase.load((ORecordInternal<?>)iRecord, this.fetchPlan);
        } else {
            iRecord = this.lowLevelDatabase.load(this.current, this.fetchPlan);
        }
        if (iRecord != null) {
            ++this.browsedRecords;
            return iRecord;
        }
        return null;
    }

    protected void updateClusterRange() {
        this.current.clusterId = this.clusterIds[this.currentClusterIdx];
        long[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
        this.firstClusterPosition = range[0];
        this.lastClusterPosition = range[1];
    }
}

