/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.iterator.ORecordIterator;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordIteratorCluster<REC extends ORecordInternal<?>>
extends ORecordIterator<REC> {
    protected long rangeFrom;
    protected long rangeTo;

    public ORecordIteratorCluster(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase, int iClusterId) {
        super(iDatabase, iLowLevelDatabase);
        if (iClusterId == -1) {
            throw new IllegalArgumentException("The clusterId is invalid");
        }
        this.current.clusterId = iClusterId;
        this.rangeFrom = -1L;
        this.rangeTo = -1L;
        long[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
        this.firstClusterPosition = range[0];
        this.lastClusterPosition = range[1];
        this.totalAvailableRecords = this.database.countClusterElements(this.current.clusterId);
        this.txEntries = iDatabase.getTransaction().getRecordEntriesByClusterIds(new int[]{iClusterId});
        if (this.txEntries != null) {
            for (OTransactionRecordEntry entry : this.txEntries) {
                switch (entry.status) {
                    case 3: {
                        ++this.totalAvailableRecords;
                        break;
                    }
                    case 2: {
                        --this.totalAvailableRecords;
                    }
                }
            }
        }
    }

    @Override
    public boolean hasPrevious() {
        this.checkDirection(false);
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        return this.current.clusterPosition > this.getRangeFrom() + 1L;
    }

    @Override
    public boolean hasNext() {
        long recordsToBrowse;
        this.checkDirection(true);
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.liveUpdated) {
            this.lastClusterPosition = this.getRangeTo();
        }
        long l = recordsToBrowse = this.current.clusterPosition > -2L && this.lastClusterPosition > -1L ? this.lastClusterPosition - this.current.clusterPosition : 0L;
        if (recordsToBrowse > 0L) {
            return true;
        }
        if (this.txEntries != null) {
            recordsToBrowse += (long)(this.txEntries.size() - (this.currentTxEntryPosition + 1));
        }
        return recordsToBrowse > 0L;
    }

    @Override
    public REC previous() {
        this.checkDirection(false);
        ORecordInternal<?> record = this.getRecord();
        while (this.hasPrevious()) {
            if ((record = this.readCurrentRecord(record, -1)) == null) continue;
            return (REC)record;
        }
        throw new NoSuchElementException();
    }

    @Override
    public REC next() {
        this.checkDirection(true);
        ORecordInternal<Object> record = this.getRecord();
        while (this.hasNext()) {
            record = this.getTransactionEntry();
            if (record != null) {
                return (REC)record;
            }
            record = this.readCurrentRecord(null, 1);
            if (record == null) continue;
            return (REC)record;
        }
        throw new NoSuchElementException();
    }

    public ORecordInternal<?> current() {
        ORecordInternal<?> record = this.getRecord();
        return this.readCurrentRecord(record, 0);
    }

    @Override
    public ORecordIterator<REC> begin() {
        this.current.clusterPosition = this.getRangeFrom();
        return this;
    }

    @Override
    public ORecordIterator<REC> last() {
        this.current.clusterPosition = this.getRangeTo();
        return this;
    }

    public ORecordIteratorCluster<REC> setRange(long iFrom, long iEnd) {
        this.firstClusterPosition = iFrom;
        this.rangeTo = iEnd;
        this.current.clusterPosition = this.firstClusterPosition;
        return this;
    }

    public long getRangeFrom() {
        if (!this.liveUpdated) {
            return this.firstClusterPosition - 1L;
        }
        long limit = this.database.getStorage().getClusterDataRange(this.current.clusterId)[0] - 1L;
        if (this.rangeFrom > -1L) {
            return Math.max(this.rangeFrom, limit);
        }
        return limit;
    }

    public long getRangeTo() {
        if (!this.liveUpdated) {
            return this.lastClusterPosition + 1L;
        }
        long limit = this.database.getStorage().getClusterDataRange(this.current.clusterId)[1] + 1L;
        if (this.rangeTo > -1L) {
            return Math.min(this.rangeTo, limit);
        }
        return limit;
    }

    @Override
    public ORecordIterator<REC> setLiveUpdated(boolean iLiveUpdated) {
        super.setLiveUpdated(iLiveUpdated);
        if (iLiveUpdated) {
            this.firstClusterPosition = -1L;
            this.lastClusterPosition = -1L;
        } else {
            long[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
            this.firstClusterPosition = range[0];
            this.lastClusterPosition = range[1];
        }
        this.totalAvailableRecords = this.database.countClusterElements(this.current.clusterId);
        return this;
    }

    private ORecordInternal<?> readCurrentRecord(ORecordInternal<?> iRecord, int iMovement) {
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return null;
        }
        this.current.clusterPosition += (long)iMovement;
        if (iRecord != null) {
            iRecord.setIdentity(this.current);
            iRecord = this.lowLevelDatabase.load((ORecordInternal<?>)iRecord, this.fetchPlan);
        } else {
            iRecord = this.lowLevelDatabase.load(this.current, this.fetchPlan);
        }
        if (iRecord != null) {
            ++this.browsedRecords;
        }
        return iRecord;
    }
}

