/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.memory;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMemoryWatchDog {
    private final Collection<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private static final MemoryPoolMXBean tenuredGenPool = OMemoryWatchDog.findTenuredGenPool();
    private int alertTimes = 0;

    public OMemoryWatchDog(float iThreshold) {
        OMemoryWatchDog.setPercentageUsageThreshold(iThreshold);
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter memEmitter = (NotificationEmitter)((Object)memBean);
        memEmitter.addNotificationListener(new NotificationListener(){

            public synchronized void handleNotification(Notification n, Object hb) {
                if (n.getType().equals("java.management.memory.threshold.exceeded")) {
                    long threshold;
                    OMemoryWatchDog.this.alertTimes++;
                    long maxMemory = tenuredGenPool.getUsage().getMax();
                    long usedMemory = tenuredGenPool.getUsage().getUsed();
                    long freeMemory = maxMemory - usedMemory;
                    OLogManager.instance().debug((Object)this, "Free memory is low %s %s%% (used %s of %s), calling listeners to free memory in SOFT way...", new Object[]{OFileUtils.getSizeAsString((long)freeMemory), freeMemory * 100L / maxMemory, OFileUtils.getSizeAsString((long)usedMemory), OFileUtils.getSizeAsString((long)maxMemory)});
                    long timer = OProfiler.getInstance().startChrono();
                    for (Listener listener : OMemoryWatchDog.this.listeners) {
                        try {
                            listener.memoryUsageLow(Listener.TYPE.JVM, usedMemory, maxMemory);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    do {
                        OMemoryWatchDog.freeMemory(300L);
                        maxMemory = tenuredGenPool.getUsage().getMax();
                        usedMemory = tenuredGenPool.getUsage().getUsed();
                        freeMemory = maxMemory - usedMemory;
                        threshold = (long)((float)maxMemory * (1.0f - OGlobalConfiguration.MEMORY_OPTIMIZE_THRESHOLD.getValueAsFloat()));
                        OLogManager.instance().debug((Object)this, "Free memory now is %s %s%% (used %s of %s) with threshold for HARD clean is %s", new Object[]{OFileUtils.getSizeAsString((long)freeMemory), freeMemory * 100L / maxMemory, OFileUtils.getSizeAsString((long)usedMemory), OFileUtils.getSizeAsString((long)maxMemory), OFileUtils.getSizeAsString((long)threshold)});
                        if (freeMemory >= threshold) continue;
                        OLogManager.instance().debug((Object)this, "Free memory is low %s %s%% (used %s of %s) while the threshold is %s, calling listeners to free memory in HARD way...", new Object[]{OFileUtils.getSizeAsString((long)freeMemory), freeMemory * 100L / maxMemory, OFileUtils.getSizeAsString((long)usedMemory), OFileUtils.getSizeAsString((long)maxMemory), OFileUtils.getSizeAsString((long)threshold)});
                        for (Listener listener : OMemoryWatchDog.this.listeners) {
                            try {
                                listener.memoryUsageCritical(Listener.TYPE.JVM, usedMemory, maxMemory);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } while (freeMemory < threshold);
                    OProfiler.getInstance().stopChrono("OMemoryWatchDog.freeResources", timer);
                }
            }
        }, null, null);
        OProfiler.getInstance().registerHookValue("memory.alerts", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OMemoryWatchDog.this.alertTimes;
            }
        });
    }

    public Collection<Listener> getListeners() {
        return this.listeners;
    }

    public Listener addListener(Listener listener) {
        this.listeners.add(listener);
        return listener;
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public static void setPercentageUsageThreshold(double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        long maxMemory = tenuredGenPool.getUsage().getMax();
        long warningThreshold = (long)((double)maxMemory * percentage);
        tenuredGenPool.setUsageThreshold(warningThreshold);
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    public static void freeMemory(long iDelayTime) {
        System.gc();
        if (iDelayTime > 0L) {
            try {
                Thread.sleep(iDelayTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static interface Listener {
        public void memoryUsageLow(TYPE var1, long var2, long var4);

        public void memoryUsageCritical(TYPE var1, long var2, long var4);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TYPE {
            OS,
            JVM;

        }
    }
}

