/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OClassImpl
extends ODocumentWrapperNoClass
implements OClass {
    protected OSchemaShared owner;
    protected String name;
    protected Class<?> javaClass;
    protected int fixedSize = 0;
    protected Map<String, OProperty> properties = new HashMap<String, OProperty>();
    protected int[] clusterIds;
    protected int defaultClusterId;
    protected OClassImpl superClass;
    protected int[] polymorphicClusterIds;
    protected List<OClass> baseClasses;
    protected float overSize = 0.0f;
    protected String shortName;

    public OClassImpl() {
    }

    protected OClassImpl(OSchemaShared iOwner) {
        this.document = new ODocument(this.getDatabase());
        this.owner = iOwner;
    }

    protected OClassImpl(OSchemaShared iOwner, ODocument iDocument) {
        this.document = iDocument;
        this.owner = iOwner;
    }

    protected OClassImpl(OSchemaShared iOwner, String iName, String iJavaClassName, int[] iClusterIds) throws ClassNotFoundException {
        this(iOwner, iName, iClusterIds);
        this.javaClass = Class.forName(iJavaClassName);
    }

    protected OClassImpl(OSchemaShared iOwner, String iName, int[] iClusterIds) {
        this(iOwner);
        this.name = iName;
        this.setClusterIds(iClusterIds);
        this.setPolymorphicClusterIds(iClusterIds);
        this.defaultClusterId = iClusterIds[0];
    }

    @Override
    public <T> T newInstance() throws InstantiationException, IllegalAccessException {
        if (this.javaClass == null) {
            throw new IllegalArgumentException("Can't create an instance of class '" + this.name + "' since no Java class was specified");
        }
        return (T)this.javaClass.newInstance();
    }

    public void validateInstances() {
        ODatabaseComplex current;
        for (current = this.getDatabase().getDatabaseOwner(); current != null && current.getUnderlying() instanceof ODatabaseComplex && !(current instanceof ODatabaseDocumentTx); current = (ODatabaseComplex)current.getUnderlying()) {
        }
        for (ODocument d : ((ODatabaseDocumentTx)current).browseClass(this.name, true)) {
            d.validate();
        }
    }

    @Override
    public OClass getSuperClass() {
        return this.superClass;
    }

    @Override
    public OClass setSuperClass(OClass iSuperClass) {
        this.document.getDatabase().checkSecurity("database.schema", 4);
        String cmd = String.format("alter class %s superclass %s", this.name, iSuperClass.getName());
        this.document.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setSuperClassInternal(iSuperClass);
        return this;
    }

    public void setSuperClassInternal(OClass iSuperClass) {
        this.superClass = (OClassImpl)iSuperClass;
        this.superClass.addBaseClasses(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OClass setName(String iName) {
        this.document.getDatabase().checkSecurity("database.schema", 4);
        String cmd = String.format("alter class %s name %s", this.name, iName);
        this.document.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.name = iName;
        return this;
    }

    public void setNameInternal(String iName) {
        this.document.getDatabase().checkSecurity("database.schema", 4);
        this.owner.changeClassName(this.name, iName);
        this.name = iName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public OClass setShortName(String iShortName) {
        this.document.getDatabase().checkSecurity("database.schema", 4);
        String cmd = String.format("alter class %s shortname %s", this.name, iShortName);
        this.document.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setShortNameInternal(iShortName);
        return this;
    }

    public void setShortNameInternal(String shortName) {
        this.document.getDatabase().checkSecurity("database.schema", 4);
        if (this.shortName != null) {
            this.owner.classes.remove(shortName);
        }
        this.shortName = shortName;
        this.owner.classes.put(shortName.toLowerCase(), this);
    }

    @Override
    public String getStreamableName() {
        return this.shortName != null ? this.shortName : this.name;
    }

    @Override
    public Collection<OProperty> declaredProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    public Collection<OProperty> properties() {
        this.document.getDatabase().checkSecurity("database.schema", 2);
        ArrayList<OProperty> props = null;
        OClassImpl currentClass = this;
        do {
            if (currentClass.properties == null) continue;
            if (props == null) {
                props = new ArrayList<OProperty>();
            }
            props.addAll(currentClass.properties.values());
        } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
        return props != null ? props : Collections.emptyList();
    }

    @Override
    public Collection<OProperty> getIndexedProperties() {
        this.document.getDatabase().checkSecurity("database.schema", 2);
        List<OProperty> indexedProps = null;
        OClassImpl currentClass = this;
        do {
            if (currentClass.properties == null) continue;
            for (OProperty p : currentClass.properties.values()) {
                if (!p.isIndexed()) continue;
                if (indexedProps == null) {
                    indexedProps = new ArrayList<OProperty>();
                }
                indexedProps.add(p);
            }
        } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
        return indexedProps != null ? indexedProps : Collections.emptyList();
    }

    @Override
    public OProperty getProperty(String iPropertyName) {
        OClassImpl currentClass = this;
        OProperty p = null;
        do {
            if (currentClass.properties != null) {
                p = currentClass.properties.get(iPropertyName.toLowerCase());
            }
            if (p == null) continue;
            return p;
        } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
        return p;
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType) {
        return this.addProperty(iPropertyName, iType, null, null);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass) {
        if (iLinkedClass == null) {
            throw new OSchemaException("Missed linked class");
        }
        return this.addProperty(iPropertyName, iType, null, iLinkedClass);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OType iLinkedType) {
        return this.addProperty(iPropertyName, iType, iLinkedType, null);
    }

    public int fixedSize() {
        return this.fixedSize;
    }

    @Override
    public boolean existsProperty(String iPropertyName) {
        return this.properties.containsKey(iPropertyName.toLowerCase());
    }

    @Override
    public void dropProperty(String iPropertyName) {
        this.document.getDatabase().checkSecurity("database.schema", 8);
        String lowerName = iPropertyName.toLowerCase();
        if (!this.properties.containsKey(lowerName)) {
            throw new OSchemaException("Property '" + iPropertyName + "' not found in class " + this.name + "'");
        }
        StringBuilder cmd = new StringBuilder("drop property ");
        cmd.append(this.name);
        cmd.append('.');
        cmd.append(iPropertyName);
        this.document.getDatabase().command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
        if (this.existsProperty(iPropertyName)) {
            this.properties.remove(lowerName);
        }
    }

    public void dropPropertyInternal(String iPropertyName) {
        this.document.getDatabase().checkSecurity("database.schema", 8);
        OProperty prop = this.properties.remove(iPropertyName.toLowerCase());
        if (prop == null) {
            throw new OSchemaException("Property '" + iPropertyName + "' not found in class " + this.name + "'");
        }
        prop.dropIndex();
        this.fixedSize -= prop.getType().size;
    }

    public OProperty addProperty(String iPropertyName, OType iType, OType iLinkedType, OClass iLinkedClass) {
        this.document.getDatabase().checkSecurity("database.schema", 4);
        String lowerName = iPropertyName.toLowerCase();
        if (this.properties.containsKey(lowerName)) {
            throw new OSchemaException("Class " + this.name + " already has the property '" + iPropertyName + "'");
        }
        StringBuilder cmd = new StringBuilder("create property ");
        cmd.append(this.name);
        cmd.append('.');
        cmd.append(iPropertyName);
        cmd.append(' ');
        cmd.append(iType.name);
        if (iLinkedType != null) {
            cmd.append(' ');
            cmd.append(iLinkedType.name);
        } else if (iLinkedClass != null) {
            cmd.append(' ');
            cmd.append(iLinkedClass.getName());
        }
        this.document.getDatabase().command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
        if (this.existsProperty(iPropertyName)) {
            return this.properties.get(lowerName);
        }
        return this.addPropertyInternal(iPropertyName, iType, iLinkedType, iLinkedClass);
    }

    @Override
    public void fromStream() {
        Object cc;
        this.name = (String)this.document.field("name");
        this.shortName = (String)this.document.field("shortName");
        this.defaultClusterId = (Integer)this.document.field("defaultClusterId");
        if (this.document.field("overSize") != null) {
            this.overSize = ((Float)this.document.field("overSize")).floatValue();
        }
        if ((cc = this.document.field("clusterIds")) instanceof Collection) {
            Collection coll = (Collection)this.document.field("clusterIds");
            this.clusterIds = new int[coll.size()];
            int i = 0;
            for (Integer item : coll) {
                this.clusterIds[i++] = item;
            }
        } else {
            this.clusterIds = (int[])cc;
        }
        Arrays.sort(this.clusterIds);
        this.setPolymorphicClusterIds(this.clusterIds);
        Collection storedProperties = (Collection)this.document.field("properties");
        for (ODocument p : storedProperties) {
            p.setDatabase(this.document.getDatabase());
            OPropertyImpl prop = new OPropertyImpl(this, p);
            prop.fromStream();
            this.properties.put(prop.getName().toLowerCase(), prop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OBeforeSerialization
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("name", this.name);
            this.document.field("shortName", this.shortName);
            this.document.field("defaultClusterId", this.defaultClusterId);
            this.document.field("clusterIds", this.clusterIds);
            this.document.field("overSize", Float.valueOf(this.overSize));
            HashSet<ODocument> props = new HashSet<ODocument>();
            for (OProperty p : this.properties.values()) {
                props.add(((OPropertyImpl)p).toStream());
            }
            this.document.field("properties", props, OType.EMBEDDEDSET);
            if (this.superClass != null) {
                this.document.field("superClass", this.superClass.getName());
            }
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    public void setDefaultClusterId(int iDefaultClusterId) {
        this.defaultClusterId = iDefaultClusterId;
        this.setDirty();
    }

    @Override
    public int[] getClusterIds() {
        return this.clusterIds;
    }

    @Override
    public int[] getPolymorphicClusterIds() {
        return this.polymorphicClusterIds;
    }

    public OClassImpl addClusterIds(int iId) {
        for (int currId : this.clusterIds) {
            if (currId != iId) continue;
            return this;
        }
        this.clusterIds = OArrays.copyOf((int[])this.clusterIds, (int)(this.clusterIds.length + 1));
        this.clusterIds[this.clusterIds.length - 1] = iId;
        Arrays.sort(this.clusterIds);
        this.setDirty();
        return this;
    }

    public OClassImpl setDirty() {
        this.document.setDirty();
        if (this.owner != null) {
            this.owner.setDirty();
        }
        return this;
    }

    @Override
    public Iterator<OClass> getBaseClasses() {
        if (this.baseClasses == null || this.baseClasses.size() == 0) {
            return null;
        }
        return this.baseClasses.iterator();
    }

    private OClassImpl addBaseClasses(OClass iBaseClass) {
        if (this.baseClasses == null) {
            this.baseClasses = new ArrayList<OClass>();
        }
        this.baseClasses.add(iBaseClass);
        for (OClassImpl currentClass = this; currentClass != null; currentClass = (OClassImpl)currentClass.getSuperClass()) {
            currentClass.addPolymorphicClusterIds((OClassImpl)iBaseClass);
        }
        return this;
    }

    @Override
    public float getOverSize() {
        if (this.overSize > 0.0f) {
            return this.overSize;
        }
        if (this.superClass != null) {
            return this.superClass.getOverSize();
        }
        return 0.0f;
    }

    @Override
    public OClass setOverSize(float overSize) {
        this.document.getDatabase().checkSecurity("database.schema", 4);
        String cmd = String.format("alter class %s oversize %f", this.name, Float.valueOf(overSize));
        this.document.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setOverSizeInternal(overSize);
        return this;
    }

    public void setOverSizeInternal(float overSize) {
        this.document.getDatabase().checkSecurity("database.schema", 4);
        this.overSize = overSize;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OClassImpl other = (OClassImpl)obj;
        return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
    }

    @Override
    public int compareTo(OClass o) {
        return this.name.compareTo(o.getName());
    }

    @Override
    public long count() {
        return this.count(true);
    }

    @Override
    public long count(boolean iPolymorphic) {
        if (iPolymorphic) {
            return this.getDatabase().countClusterElements(this.polymorphicClusterIds);
        }
        return this.getDatabase().countClusterElements(this.clusterIds);
    }

    private ODatabaseRecord getDatabase() {
        return (ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public void truncate() throws IOException {
        for (int id : this.clusterIds) {
            this.getDatabase().getStorage().getClusterById(id).truncate();
        }
    }

    @Override
    public boolean isSubClassOf(String iClassName) {
        return this.isSubClassOf(this.owner.getClass(iClassName));
    }

    @Override
    public boolean isSubClassOf(OClass iClass) {
        if (iClass == null) {
            return false;
        }
        for (OClass cls = this; cls != null; cls = cls.getSuperClass()) {
            if (!cls.getName().equals(iClass.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuperClassOf(OClass iClass) {
        for (OClass cls = iClass; cls != null; cls = cls.getSuperClass()) {
            if (!cls.equals(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(OClass.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case NAME: {
                return this.getName();
            }
            case SHORTNAME: {
                return this.getShortName();
            }
            case SUPERCLASS: {
                return this.getSuperClass();
            }
            case OVERSIZE: {
                return Float.valueOf(this.getOverSize());
            }
        }
        throw new IllegalArgumentException("Can't find attribute '" + (Object)((Object)iAttribute) + "'");
    }

    public void setInternalAndSave(OClass.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (attribute) {
            case NAME: {
                this.setNameInternal(stringValue);
                break;
            }
            case SHORTNAME: {
                this.setShortNameInternal(stringValue);
                break;
            }
            case SUPERCLASS: {
                this.setSuperClassInternal(this.document.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case OVERSIZE: {
                this.setOverSizeInternal(Float.parseFloat(stringValue.replace(',', '.')));
            }
        }
        this.saveInternal();
    }

    @Override
    public OClass set(OClass.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (attribute) {
            case NAME: {
                this.setName(stringValue);
                break;
            }
            case SHORTNAME: {
                this.setShortName(stringValue);
                break;
            }
            case SUPERCLASS: {
                this.setSuperClass(this.document.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case OVERSIZE: {
                this.setOverSize(Float.parseFloat(stringValue));
            }
        }
        return this;
    }

    private void addPolymorphicClusterIds(OClassImpl iBaseClass) {
        for (int i : iBaseClass.polymorphicClusterIds) {
            boolean found = false;
            for (int k : this.clusterIds) {
                if (i != k) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.polymorphicClusterIds = OArrays.copyOf((int[])this.polymorphicClusterIds, (int)(this.polymorphicClusterIds.length + 1));
            this.polymorphicClusterIds[this.polymorphicClusterIds.length - 1] = i;
            Arrays.sort(this.polymorphicClusterIds);
        }
    }

    public OPropertyImpl addPropertyInternal(String iName, OType iType, OType iLinkedType, OClass iLinkedClass) {
        if (iName == null || iName.length() == 0) {
            throw new OSchemaException("Found property name null");
        }
        Character wrongCharacter = OSchemaShared.checkNameIfValid(iName);
        if (wrongCharacter != null) {
            throw new OSchemaException("Found invalid property name. Character '" + wrongCharacter + "' can't be used in property name.");
        }
        String lowerName = iName.toLowerCase();
        if (this.properties.containsKey(lowerName)) {
            throw new OSchemaException("Class " + this.name + " already has the property '" + iName + "'");
        }
        OPropertyImpl prop = new OPropertyImpl(this, iName, iType);
        this.properties.put(lowerName, prop);
        this.fixedSize += iType.size;
        if (iLinkedType != null) {
            prop.setLinkedTypeInternal(iLinkedType);
        } else if (iLinkedClass != null) {
            prop.setLinkedClassInternal(iLinkedClass);
        }
        return prop;
    }

    public void saveInternal() {
        this.owner.saveInternal();
    }

    private void setPolymorphicClusterIds(int[] iClusterIds) {
        this.polymorphicClusterIds = iClusterIds;
        Arrays.sort(this.polymorphicClusterIds);
    }

    private void setClusterIds(int[] iClusterIds) {
        this.clusterIds = iClusterIds;
        Arrays.sort(this.clusterIds);
    }
}

