/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OType {
    BOOLEAN("Boolean", 0, false, true, 1, new Class[]{Boolean.class, Boolean.TYPE}, new Class[]{Boolean.class}){}
    ,
    INTEGER("Integer", 1, false, true, 4, new Class[]{Integer.class, Integer.TYPE}, new Class[]{Number.class}){}
    ,
    SHORT("Short", 2, false, true, 2, new Class[]{Short.class, Short.TYPE}, new Class[]{Number.class}){}
    ,
    LONG("Long", 3, false, true, 8, new Class[]{Long.class, Long.TYPE}, new Class[]{Number.class}){}
    ,
    FLOAT("Float", 4, false, true, 4, new Class[]{Float.class, Float.TYPE}, new Class[]{Number.class}){}
    ,
    DOUBLE("Double", 5, false, true, 8, new Class[]{Double.class, Double.TYPE}, new Class[]{Number.class}){}
    ,
    DATETIME("Datetime", 6, false, true, 8, new Class[]{Date.class}, new Class[]{Date.class, Long.class}){}
    ,
    STRING("String", 7, false, false, 8, new Class[]{String.class}, new Class[]{String.class}){}
    ,
    BINARY("Binary", 8, false, false, 8, new Class[]{Array.class}, new Class[]{Array.class}){}
    ,
    EMBEDDED("Embedded", 9, true, false, 8, new Class[]{Object.class}, new Class[]{Object.class}){}
    ,
    EMBEDDEDLIST("EmbeddedList", 10, true, false, 8, new Class[]{List.class}, new Class[]{Collection.class, Array.class}){}
    ,
    EMBEDDEDSET("EmbeddedSet", 11, true, false, 8, new Class[]{Set.class}, new Class[]{Collection.class, Array.class}){}
    ,
    EMBEDDEDMAP("EmbeddedMap", 12, true, false, 8, new Class[]{Map.class}, new Class[]{Map.class}){}
    ,
    LINK("Link", 13, true, true, 8, new Class[]{Object.class, ORecordId.class}, new Class[]{ORecord.class, ORID.class}){}
    ,
    LINKLIST("LinkList", 14, true, false, 8, new Class[]{List.class}, new Class[]{Collection.class, Array.class}){}
    ,
    LINKSET("LinkSet", 15, true, false, 8, new Class[]{Set.class}, new Class[]{Collection.class, Array.class}){}
    ,
    LINKMAP("LinkMap", 16, true, false, 8, new Class[]{Map.class}, new Class[]{Map.class}){}
    ,
    BYTE("Byte", 17, false, true, 1, new Class[]{Byte.class, Byte.TYPE}, new Class[]{Number.class, Character.class}){}
    ,
    TRANSIENT("Transient", 18, false, true, 0, new Class[0], new Class[0]){}
    ,
    DATE("Date", 19, false, true, 8, new Class[]{Date.class}, new Class[]{Date.class, Long.class}){};

    protected static final OType[] TYPES;
    protected String name;
    protected int id;
    protected boolean complex;
    protected boolean fixedSize;
    protected int size;
    protected Class<?>[] javaTypes;
    protected Class<?>[] allowAssignmentFrom;

    private OType(String iName, int iId, boolean iComplex, boolean iFixedSize, int iSize, Class<?>[] iJavaTypes, Class<?>[] iAllowAssignmentBy) {
        this.name = iName;
        this.id = iId;
        this.complex = iComplex;
        this.fixedSize = iFixedSize;
        this.size = iSize;
        this.javaTypes = iJavaTypes;
        this.allowAssignmentFrom = iAllowAssignmentBy;
    }

    public static OType getById(byte iId) {
        for (OType t : TYPES) {
            if (iId != t.id) continue;
            return t;
        }
        return null;
    }

    public boolean isAssignableFrom(Object iPropertyValue) {
        if (iPropertyValue == null) {
            return true;
        }
        Class<?> cls = iPropertyValue.getClass();
        for (int i = 0; i < this.allowAssignmentFrom.length; ++i) {
            if (this.allowAssignmentFrom[i].equals(Array.class) && cls.isArray()) {
                return true;
            }
            if (!this.allowAssignmentFrom[i].isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public static OType getTypeByClass(Class<?> iClass) {
        if (iClass == null) {
            return null;
        }
        for (OType type : TYPES) {
            for (int i = 0; i < type.javaTypes.length; ++i) {
                if (type.javaTypes[i] != iClass) continue;
                return type;
            }
        }
        if (ORecord.class.isAssignableFrom(iClass)) {
            return LINK;
        }
        return null;
    }

    public static OType getTypeByAssignability(Class<?> iClass) {
        if (iClass == null) {
            return null;
        }
        for (OType type : TYPES) {
            for (int i = 0; i < type.allowAssignmentFrom.length; ++i) {
                if (!type.allowAssignmentFrom[i].isAssignableFrom(iClass)) continue;
                return type;
            }
        }
        return null;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public int asInt(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).intValue();
        }
        if (iValue instanceof String) {
            return Integer.valueOf((String)iValue);
        }
        if (iValue instanceof Boolean) {
            return (Boolean)iValue != false ? 1 : 0;
        }
        throw new IllegalArgumentException("Can't convert value " + iValue + " to int for the type: " + this.name);
    }

    public long asLong(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).longValue();
        }
        if (iValue instanceof String) {
            return Long.valueOf((String)iValue);
        }
        if (iValue instanceof Boolean) {
            return (Boolean)iValue != false ? 1L : 0L;
        }
        throw new IllegalArgumentException("Can't convert value " + iValue + " to long for the type: " + this.name);
    }

    public float asFloat(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).intValue();
        }
        if (iValue instanceof String) {
            return Float.valueOf((String)iValue).floatValue();
        }
        throw new IllegalArgumentException("Can't convert value " + iValue + " to float for the type: " + this.name);
    }

    public double asDouble(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).doubleValue();
        }
        if (iValue instanceof String) {
            return Double.valueOf((String)iValue);
        }
        throw new IllegalArgumentException("Can't convert value " + iValue + " to double for the type: " + this.name);
    }

    public String asString(Object iValue) {
        return iValue.toString();
    }

    public static boolean isSimpleType(Object iObject) {
        if (iObject == null) {
            return false;
        }
        Class<?> iType = iObject.getClass();
        return iType.isPrimitive() || Number.class.isAssignableFrom(iType) || String.class.isAssignableFrom(iType) || Boolean.class.isAssignableFrom(iType) || Date.class.isAssignableFrom(iType) || iType.isArray() && (iType.equals(byte[].class) || iType.equals(char[].class));
    }

    public static Object convert(Object iValue, Class<?> iTargetClass) {
        if (iValue == null) {
            return null;
        }
        if (iValue.getClass().equals(iTargetClass)) {
            return iValue;
        }
        if (iTargetClass.isAssignableFrom(iValue.getClass())) {
            return iValue;
        }
        try {
            if (byte[].class.isAssignableFrom(iTargetClass)) {
                return OBase64Utils.decode(iValue.toString());
            }
            if (byte[].class.isAssignableFrom(iValue.getClass())) {
                return iValue;
            }
            if (iTargetClass.isEnum()) {
                if (iValue instanceof Number) {
                    return ((Enum[])iTargetClass.getEnumConstants())[((Number)iValue).intValue()];
                }
                return Enum.valueOf(iTargetClass, iValue.toString());
            }
            if (iTargetClass.equals(Byte.TYPE) || iTargetClass.equals(Byte.class)) {
                if (iValue instanceof Byte) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Byte.parseByte((String)iValue);
                }
                return ((Number)iValue).byteValue();
            }
            if (iTargetClass.equals(Short.TYPE) || iTargetClass.equals(Short.class)) {
                if (iValue instanceof Short) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Short.parseShort((String)iValue);
                }
                return ((Number)iValue).shortValue();
            }
            if (iTargetClass.equals(Integer.TYPE) || iTargetClass.equals(Integer.class)) {
                if (iValue instanceof Integer) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Integer.parseInt((String)iValue);
                }
                return ((Number)iValue).intValue();
            }
            if (iTargetClass.equals(Long.TYPE) || iTargetClass.equals(Long.class)) {
                if (iValue instanceof Long) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Long.parseLong((String)iValue);
                }
                return ((Number)iValue).longValue();
            }
            if (iTargetClass.equals(Float.TYPE) || iTargetClass.equals(Float.class)) {
                if (iValue instanceof Float) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)iValue));
                }
                return Float.valueOf(((Number)iValue).floatValue());
            }
            if (iTargetClass.equals(Double.TYPE) || iTargetClass.equals(Double.class)) {
                if (iValue instanceof Double) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Double.parseDouble((String)iValue);
                }
                return ((Number)iValue).doubleValue();
            }
            if (iTargetClass.equals(Boolean.TYPE) || iTargetClass.equals(Boolean.class)) {
                if (iValue instanceof Boolean) {
                    return (boolean)((Boolean)iValue);
                }
                if (iValue instanceof String) {
                    return Boolean.parseBoolean((String)iValue);
                }
                if (iValue instanceof Number) {
                    return ((Number)iValue).intValue() != 0;
                }
            } else {
                if (iValue instanceof Collection && Set.class.isAssignableFrom(iTargetClass)) {
                    HashSet set = new HashSet();
                    set.addAll((Collection)iValue);
                    return set;
                }
                if (iTargetClass.equals(Date.class)) {
                    if (iValue instanceof Number) {
                        return new Date(((Number)iValue).longValue());
                    }
                    if (iValue instanceof String) {
                        try {
                            return ((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get()).getStorage().getConfiguration().getDateTimeFormatInstance().parse((String)iValue);
                        }
                        catch (ParseException e) {
                            return ((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get()).getStorage().getConfiguration().getDateFormatInstance().parse((String)iValue);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(OType.class, "Error in conversion of value '%s' to type '%s'", new Object[]{iValue, iTargetClass});
        }
        return null;
    }

    public Class<?> getDefaultJavaType() {
        return this.javaTypes.length > 0 ? this.javaTypes[0] : null;
    }

    public Class<?>[] getJavaTypes() {
        return this.javaTypes;
    }

    static {
        TYPES = new OType[]{BOOLEAN, BYTE, INTEGER, SHORT, LONG, FLOAT, DOUBLE, DATE, DATETIME, STRING, BINARY, EMBEDDED, EMBEDDEDLIST, EMBEDDEDSET, EMBEDDEDMAP, LINK, LINKLIST, LINKSET, LINKMAP, TRANSIENT};
    }
}

