/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.annotation.OBeforeDeserialization;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORole
extends ODocumentWrapper {
    public static final String ADMIN = "admin";
    public static final int PERMISSION_NONE = 0;
    public static final int PERMISSION_CREATE = 1;
    public static final int PERMISSION_READ = 2;
    public static final int PERMISSION_UPDATE = 4;
    public static final int PERMISSION_DELETE = 8;
    public static final int PERMISSION_ALL = 15;
    public static final String PERMISSION_CREATE_TEXT = "Create";
    public static final String PERMISSION_READ_TEXT = "Read";
    public static final String PERMISSION_UPDATE_TEXT = "Update";
    public static final String PERMISSION_DELETE_TEXT = "Delete";
    protected static final byte STREAM_DENY = 0;
    protected static final byte STREAM_ALLOW = 1;
    protected ALLOW_MODES mode = ALLOW_MODES.DENY_ALL_BUT;
    protected ORole parentRole;
    protected Map<String, Byte> rules = new LinkedHashMap<String, Byte>();

    public ORole() {
    }

    public ORole(ODatabaseRecord iDatabase) {
        super(iDatabase, "ORole");
    }

    public ORole(ODatabaseRecord iDatabase, String iName, ORole iParent, ALLOW_MODES iAllowMode) {
        this(iDatabase);
        this.document.field("name", iName);
        this.parentRole = iParent;
        this.document.field("inheritedRole", this.parentRole != null ? this.parentRole.getName() : null);
        this.setMode(iAllowMode);
        this.document.field("rules", new HashMap());
    }

    public ORole(ODocument iSource) {
        this.fromStream(iSource);
    }

    @Override
    @OBeforeDeserialization
    public void fromStream(ODocument iSource) {
        if (this.document != null) {
            return;
        }
        this.document = iSource;
        this.mode = ((Number)this.document.field("mode")).byteValue() == 1 ? ALLOW_MODES.ALLOW_ALL_BUT : ALLOW_MODES.DENY_ALL_BUT;
        String roleName = (String)this.document.field("inheritedRole");
        this.parentRole = roleName != null ? this.document.getDatabase().getMetadata().getSecurity().getRole(roleName) : null;
        Map storedRules = (Map)this.document.field("rules");
        for (Map.Entry a : storedRules.entrySet()) {
            this.rules.put((String)a.getKey(), ((Number)a.getValue()).byteValue());
        }
    }

    public boolean allow(String iResource, int iCRUDOperation) {
        Byte access = this.rules.get(iResource);
        if (access != null) {
            byte mask = (byte)iCRUDOperation;
            return (access & mask) == mask;
        }
        return this.mode == ALLOW_MODES.ALLOW_ALL_BUT;
    }

    public boolean hasRule(String iResource) {
        return this.rules.containsKey(iResource);
    }

    public void addRule(String iResource, int iOperation) {
        this.rules.put(iResource, (byte)iOperation);
        this.document.field("rules", this.rules);
    }

    public void grant(String iResource, int iOperation) {
        Byte current = this.rules.get(iResource);
        byte currentValue = current == null ? (byte)0 : current;
        currentValue = (byte)(currentValue | (byte)iOperation);
        this.rules.put(iResource, currentValue);
        this.document.field("rules", this.rules);
    }

    public void revoke(String iResource, int iOperation) {
        byte currentValue;
        if (iOperation == 0) {
            return;
        }
        Byte current = this.rules.get(iResource);
        if (current == null) {
            currentValue = 0;
        } else {
            currentValue = current;
            currentValue = (byte)(currentValue & ~((byte)iOperation));
        }
        this.rules.put(iResource, currentValue);
        this.document.field("rules", this.rules);
    }

    public String getName() {
        return (String)this.document.field("name");
    }

    public ALLOW_MODES getMode() {
        return this.mode;
    }

    public ORole setMode(ALLOW_MODES iMode) {
        this.mode = iMode;
        this.document.field("mode", this.mode == ALLOW_MODES.ALLOW_ALL_BUT ? (byte)1 : 0);
        return this;
    }

    public ORole getParentRole() {
        return this.parentRole;
    }

    public ORole setParentRole(ORole iParent) {
        this.parentRole = iParent;
        this.document.field("inheritedRole", this.parentRole != null ? this.parentRole.getName() : null);
        return this;
    }

    public ORole save() {
        this.document.save(ORole.class.getSimpleName());
        return this;
    }

    public Map<String, Byte> getRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static String permissionToString(int iPermission) {
        switch (iPermission) {
            case 1: {
                return PERMISSION_CREATE_TEXT;
            }
            case 2: {
                return PERMISSION_READ_TEXT;
            }
            case 4: {
                return PERMISSION_UPDATE_TEXT;
            }
            case 8: {
                return PERMISSION_DELETE_TEXT;
            }
        }
        return "Unknown permission: " + iPermission;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ALLOW_MODES {
        DENY_ALL_BUT,
        ALLOW_ALL_BUT;

    }
}

