/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSecurityShared
extends OSharedResourceAbstract
implements OSecurity,
OCloseable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUser authenticate(String iUserName, String iUserPassword) {
        OUser oUser;
        this.acquireExclusiveLock();
        try {
            String dbName = this.getDatabase().getName();
            OUser user = this.getUser(iUserName);
            if (user == null) {
                throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
            }
            if (user.getAccountStatus() != OUser.STATUSES.ACTIVE) {
                throw new OSecurityAccessException(dbName, "User '" + iUserName + "' is not active");
            }
            if (this.getDatabase().getStorage() instanceof OStorageEmbedded && !user.checkPassword(iUserPassword)) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
            }
            oUser = user;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUser getUser(String iUserName) {
        block3: {
            OUser oUser;
            this.acquireExclusiveLock();
            try {
                List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser where name = '" + iUserName + "'").setFetchPlan("*:-1")).execute(new Object[0]);
                if (result == null || result.size() <= 0) break block3;
                oUser = new OUser((ODocument)result.get(0));
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oUser;
        }
        OUser oUser = null;
        Object var5_6 = null;
        this.releaseExclusiveLock();
        return oUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUser createUser(String iUserName, String iUserPassword, String[] iRoles) {
        OUser oUser;
        this.acquireExclusiveLock();
        try {
            OUser user = new OUser(this.getDatabase(), iUserName, iUserPassword);
            if (iRoles != null) {
                for (String r : iRoles) {
                    user.addRole(r);
                }
            }
            oUser = user.save();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORole getRole(String iRoleName) {
        block3: {
            ORole oRole;
            this.acquireExclusiveLock();
            try {
                List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole where name = '" + iRoleName + "'").setFetchPlan("*:-1")).execute(new Object[0]);
                if (result == null || result.size() <= 0) break block3;
                oRole = new ORole((ODocument)result.get(0));
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oRole;
        }
        ORole oRole = null;
        Object var5_6 = null;
        this.releaseExclusiveLock();
        return oRole;
    }

    @Override
    public ORole createRole(String iRoleName, ORole.ALLOW_MODES iAllowMode) {
        return this.createRole(iRoleName, null, iAllowMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORole createRole(String iRoleName, ORole iParent, ORole.ALLOW_MODES iAllowMode) {
        ORole oRole;
        this.acquireExclusiveLock();
        try {
            ORole role = new ORole(this.getDatabase(), iRoleName, iParent, iAllowMode);
            oRole = role.save();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ODocument> getUsers() {
        List list;
        this.acquireExclusiveLock();
        try {
            list = (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser")).execute(new Object[0]);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ODocument> getRoles() {
        List list;
        this.acquireExclusiveLock();
        try {
            list = (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole")).execute(new Object[0]);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUser create() {
        OUser oUser;
        this.acquireExclusiveLock();
        try {
            if (this.getDatabase().getMetadata().getSchema().getClasses().size() > 0) {
                throw new OSecurityException("Default users and roles already installed");
            }
            OClass roleClass = this.getDatabase().getMetadata().getSchema().createClass("ORole");
            roleClass.createProperty("mode", OType.BYTE);
            roleClass.createProperty("rules", OType.EMBEDDEDMAP, OType.BYTE);
            OClass userClass = this.getDatabase().getMetadata().getSchema().createClass("OUser");
            userClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(false);
            userClass.createProperty("password", OType.STRING).setMandatory(true).setNotNull(false);
            userClass.createProperty("roles", OType.LINKSET, roleClass);
            ORole adminRole = this.createRole("admin", ORole.ALLOW_MODES.ALLOW_ALL_BUT);
            OUser adminUser = this.createUser("admin", "admin", new String[]{adminRole.getName()});
            ORole readerRole = this.createRole("reader", ORole.ALLOW_MODES.DENY_ALL_BUT);
            readerRole.addRule("database", 2);
            readerRole.addRule("database.schema", 2);
            readerRole.addRule("database.cluster.internal", 2);
            readerRole.addRule("database.cluster.orole", 2);
            readerRole.addRule("database.cluster.ouser", 2);
            readerRole.addRule("database.class.*", 2);
            readerRole.addRule("database.cluster.*", 2);
            readerRole.addRule("database.query", 2);
            readerRole.addRule("database.command", 2);
            readerRole.addRule("database.hook.record", 2);
            readerRole.save();
            this.createUser("reader", "reader", new String[]{readerRole.getName()});
            ORole writerRole = this.createRole("writer", ORole.ALLOW_MODES.DENY_ALL_BUT);
            writerRole.addRule("database", 2);
            writerRole.addRule("database.schema", 7);
            writerRole.addRule("database.cluster.internal", 2);
            writerRole.addRule("database.cluster.orole", 2);
            writerRole.addRule("database.cluster.ouser", 2);
            writerRole.addRule("database.class.*", 15);
            writerRole.addRule("database.cluster.*", 15);
            writerRole.addRule("database.query", 2);
            writerRole.addRule("database.command", 15);
            writerRole.addRule("database.hook.record", 15);
            writerRole.save();
            this.createUser("writer", "writer", new String[]{writerRole.getName()});
            oUser = adminUser;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oUser;
    }

    @Override
    public void close() {
    }

    @Override
    public void load() {
    }

    private ODatabaseRecord getDatabase() {
        return (ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

