/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.nativ;

import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.query.nativ.ONativeQuery;
import com.orientechnologies.orient.core.query.nativ.OQueryContextNative;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordBrowsingListener;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ONativeAsynchQuery<T extends ORecordInternal<?>, CTX extends OQueryContextNative<T>>
extends ONativeQuery<T, CTX>
implements ORecordBrowsingListener {
    protected OCommandResultListener resultListener;
    protected int resultCount = 0;
    protected ORecordInternal<?> record;

    public ONativeAsynchQuery(ODatabaseRecord iDatabase, String iCluster, CTX iQueryRecordImpl) {
        this(iDatabase, iCluster, iQueryRecordImpl, null);
    }

    public ONativeAsynchQuery(ODatabaseRecord iDatabase, String iCluster, CTX iQueryRecordImpl, OCommandResultListener iResultListener) {
        super(iDatabase, iCluster);
        this.resultListener = iResultListener;
        this.queryRecord = iQueryRecordImpl;
        this.record = new ODocument(this.database);
    }

    public boolean isAsynchronous() {
        return this.resultListener != this;
    }

    @Override
    public boolean foreach(ORecordInternal<?> iRecord) {
        ORecordInternal<?> record = iRecord;
        this.queryRecord.setRecord(record);
        if (this.filter(this.queryRecord)) {
            ++this.resultCount;
            this.resultListener.result(record.copy());
            if (this.limit > -1 && this.resultCount == this.limit) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<T> run(Object ... iArgs) {
        if (!(this.database.getStorage() instanceof OStorageEmbedded)) {
            throw new OCommandExecutionException("Native queries can run only in embedded-local version. Not in the remote one.");
        }
        this.queryRecord.setSourceQuery(this);
        OClass cls = this.database.getMetadata().getSchema().getClass(this.cluster);
        if (cls == null) {
            throw new OCommandExecutionException("Cluster " + this.cluster + " was not found");
        }
        ((OStorageEmbedded)this.database.getStorage()).browse(cls.getPolymorphicClusterIds(), null, null, this, this.record, false);
        return null;
    }

    @Override
    public T runFirst(Object ... iArgs) {
        this.setLimit(1);
        this.execute(new Object[0]);
        return null;
    }

    @Override
    public OCommandResultListener getResultListener() {
        return this.resultListener;
    }

    @Override
    public void setResultListener(OCommandResultListener resultListener) {
        this.resultListener = resultListener;
    }
}

